% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage_helpers.R
\name{coverage_to_dt}
\alias{coverage_to_dt}
\title{Convert coverage RleList to data.table}
\usage{
coverage_to_dt(
  coverage,
  keep.names = TRUE,
  withFrames = FALSE,
  weight = "score",
  drop.zero.dt = FALSE,
  fraction = NULL
)
}
\arguments{
\item{coverage}{RleList with names}

\item{keep.names}{logical (TRUE), keep names or not. If as.data.table is TRUE,
names (genes column) will be a factor column, if FALSE it will be an
integer column (index of gene), so first input grl element is 1. Dropping names
gives ~ 20 \% speedup. If drop.zero.dt is FALSE, data.table will not
return names, will use index (to avoid memory explosion).}

\item{withFrames}{a logical (FALSE), only available if as.data.table is
TRUE, return the ORF frame, 1,2,3, where position 1 is 1, 2 is 2 and
4 is 1 etc.}

\item{weight}{(default: 'score'), if defined a character name
of valid meta column in subject. GRanges("chr1", 1, "+", score = 5),
would mean score column tells that this alignment region was found 5 times.
Formats which loads a score column like this:
Bigwig, wig, ORFik ofst, collapsed bam, bedoc and .bedo.
As do CAGEr CAGE files and many other package formats.
You can also assign a score column manually.}

\item{drop.zero.dt}{logical FALSE, if TRUE and as.data.table is TRUE,
remove all 0 count positions.
This greatly speeds up and most importantly, greatly reduces memory usage.
Will not change any plots, unless 0 positions are used in some sense.
(mean, median, zscore coverage will only scale differently)}

\item{fraction}{integer or character, a description column. Useful for grouping
multiple outputs together. If returned as Rle, this
is added as: metadata(coverage) <- list(fraction = fraction). If as.data.table
it will be added as an additional column.}
}
\value{
a data.table with column names c("count" [numeric or integer],
 "genes" [integer], "position" [integer])
}
\description{
Convert coverage RleList to data.table
}
