% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRA_helper.R
\name{download.ebi}
\alias{download.ebi}
\title{Faster download of fastq files}
\usage{
download.ebi(
  info,
  outdir,
  rename = TRUE,
  ebiDLMethod = "auto",
  timeout = 5000,
  BPPARAM = bpparam()
)
}
\arguments{
\item{info}{character vector of only SRR numbers or
a data.frame with SRA metadata information including the SRR numbers in a column called
"Run" or "SRR". Can be SRR, ERR or DRR numbers.
If only SRR numbers can not rename, since no additional information is given.}

\item{outdir}{directory to store runs,
files are named by default (rename = TRUE) by information from SRA metadata table,
if (rename = FALSE) named according to SRR numbers.}

\item{rename}{logical or character, default TRUE (Auto guess new names). False: Skip
renaming. A character vector of equal size as files wanted can also be given.
Priority of renaming from
the metadata is to check for unique names in the LibraryName column,
then the sample_title column if no valid names in LibraryName.
If new names found and still duplicates, will
add "_rep1", "_rep2" to make them unique. If no valid names, will not
rename, that is keep the SRR numbers, you then can manually rename files
to something more meaningful.}

\item{ebiDLMethod}{character, default "auto". Which download protocol
to use in download.file when using ebi ftp download. Sometimes "curl"
is might not work (the default auto usually), in those cases use wget.
See "method" argument of ?download.file, for more info.}

\item{timeout}{5000, how many seconds before killing download if
still active? Will overwrite global option until R session is closed.
Increase value if you are on a very slow connection or downloading a large dataset.}

\item{BPPARAM}{how many cores/threads to use? default: bpparam().
To see number of threads used, do \code{bpparam()$workers}}
}
\value{
character, full filepath of downloaded  files
}
\description{
Uses ftp download from vol1 drive on EBI ftp server,
 for faster download of ERR, SRR or DRR files.
But does not support subsetting or custom settings of files!
}
\seealso{
Other sra: 
\code{\link{browseSRA}()},
\code{\link{download.SRA}()},
\code{\link{download.SRA.metadata}()},
\code{\link{get_bioproject_candidates}()},
\code{\link{install.sratoolkit}()},
\code{\link{rename.SRA.files}()}
}
\concept{sra}
\keyword{internal}
