% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment.R
\name{filepath}
\alias{filepath}
\title{Get filepaths to ORFik experiment}
\usage{
filepath(
  df,
  type,
  basename = FALSE,
  fallback = type \%in\% c("pshifted", "bed", "ofst", "bedoc", "bedo"),
  suffix_stem = "AUTO",
  base_folders = libFolder(df, unique_mappers = only_unique_mappers),
  only_unique_mappers = uniqueMappers(df) & type != "default"
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}}

\item{type}{a character(default: "default"), load files in experiment
or some precomputed variant, like "ofst" or "pshifted".
These are made with ORFik:::convertLibs(),
shiftFootprintsByExperiment(), etc.
Can also be custom user made folders inside the experiments bam folder.
It acts in a recursive manner with priority: If you state "pshifted",
but it does not exist, it checks "ofst". If no .ofst files, it uses
"default", which always must exists.\cr Presets are (folder is relative
to default lib folder, some types fall back to other formats if folder does not exist):\cr
- "default": load the original files for experiment, usually bam.\cr
- "ofst": loads ofst files from the ofst folder, relative to lib folder (falls back to default)\cr
- "pshifted": loads ofst, wig or bigwig from pshifted folder (falls back to ofst, then default)\cr
- "cov": Load covRle objects from cov_RLE folder (fail if not found)\cr
- "covl": Load covRleList objects, from cov_RLE_List folder (fail if not found)\cr
- "bed": Load bed files, from bed folder (falls back to default)\cr
- Other formats must be loaded directly with fimport}

\item{basename}{logical, default (FALSE).
Get relative paths instead of full. Only use for inspection!}

\item{fallback}{logical, default: type %in% c("pshifted", "bed", "ofst", "bedoc", "bedo").
If TRUE, will use type fallback, see above for info.}

\item{suffix_stem}{character, default "AUTO". Which is "" for all except
type = "pshifted". Then it is "_pshifted" appended to end of names before
format. Can be vector, then it searches suffixes in priority: so if you insert
 c("_pshifted", ""), it will look for suffix _pshifted, then the empty suffix.}

\item{base_folders}{character vector, default libFolder(df),
path to base folder to search for library variant directories.
If single path (length == 1), it will apply to all libraries in df.
If df is a collection, an experiment where libraries are put in different
folders and library variants like pshifted are put inside those respective
folders, set base_folders = libFolder(df, mode = "all")}

\item{only_unique_mappers}{logical, default \code{uniqueMappers(df)}.
Load file of only unique format type, located in './unique_mappers' relative
to bam files / default files. See ?uniqueMappers for more information.}
}
\value{
a character vector of paths, or a list of character with 2 paths per,
if paired libraries exists
}
\description{
If other type than "default" is given and that type is not found
(and 'fallback' is TRUE), it will return you ofst files, if they do not exist,
then default filepaths without warning. \cr
}
\details{
For pshifted libraries, if "pshifted" is specified as type: if
 if multiple formats exist it will use a priority:
 ofst -> bigwig -> wig -> bed. For formats outside default, all files
must be stored in the directory of the first file:
\code{base_folder <- libFolder(df)}
}
\examples{
df <- ORFik.template.experiment()
filepath(df, "default")
# Subset
filepath(df[9,], "default")
# Other format path
filepath(df[9,], "ofst")
## If you have pshifted files, see shiftFootprintsByExperiment()
filepath(df[9,], "pshifted") # <- falls back to ofst
}
\seealso{
Other ORFik_experiment: 
\code{\link{ORFik.template.experiment}()},
\code{\link{ORFik.template.experiment.zf}()},
\code{\link{bamVarName}()},
\code{\link{create.experiment}()},
\code{\link{experiment-class}},
\code{\link{libraryTypes}()},
\code{\link{organism,experiment-method}},
\code{\link{outputLibs}()},
\code{\link{read.experiment}()},
\code{\link{save.experiment}()},
\code{\link{validateExperiments}()}
}
\concept{ORFik_experiment}
