% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage_heatmaps.R
\name{heatMapL}
\alias{heatMapL}
\title{Coverage heatmap of multiple libraries}
\usage{
heatMapL(
  region,
  tx,
  df,
  outdir,
  scores = "sum",
  upstream,
  downstream,
  zeroPosition = upstream,
  acceptedLengths = NULL,
  type = "ofst",
  legendPos = "right",
  colors = "default",
  addFracPlot = TRUE,
  location = "TIS",
  shifting = NULL,
  skip.last = FALSE,
  plot.ext = ".pdf",
  plot.together = TRUE,
  title = TRUE,
  scale_x = 5.5,
  scale_y = 15.5,
  gradient.max = "default",
  BPPARAM = BiocParallel::SerialParam()
)
}
\arguments{
\item{region}{#' a \code{\link{GRangesList}} object of region,
usually either leaders, cds', 3' utrs or ORFs, start region, stop regions etc.
This is the region that will be mapped in heatmap}

\item{tx}{default NULL, a GRangesList of transcripts or (container region),
names of tx must contain all grl names. The names of grl can also be the
ORFik orf names. that is "txName_id"}

\item{df}{an ORFik \code{\link{experiment}}}

\item{outdir}{a character path to directory to save plot, will be named
from ORFik experiment columns}

\item{scores}{character vector, default \code{c("transcriptNormalized", "sum")},
either of zscore, transcriptNormalized, sum, mean, median, ..
see ?coverageScorings for info and more alternatives.}

\item{upstream}{1 or 2 integers, default c(50, 30), how long upstream from 0
should window extend (first index is 5' end extension, second is 3' end extension).
If only 1 shifting, only 1 value should be given, if two are given will use first.}

\item{downstream}{1 or 2 integers, default c(29, 69), how long upstream from 0
should window extend (first index is 5' end extension, second is 3' end extension).
If only 1 shifting, only 1 value should be given, if two are given will use first.}

\item{zeroPosition}{an integer DEFAULT (upstream), what is the center point?
Like leaders and cds combination, then 0 is the TIS and -1 is last base in leader.
NOTE!: if windows have different widths, this will be ignored.}

\item{acceptedLengths}{an integer vector (NULL), the read lengths accepted.
Default NULL, means all lengths accepted.}

\item{type}{character, default: "ofst". Type of library:
either "default", usually bam format (the one you gave to experiment),
"pshifted" pshifted reads, "ofst", "bed", "bedo" optimized bed, or "wig"}

\item{legendPos}{a character, Default "right". Where should the fill legend
be ? ("top", "bottom", "right", "left")}

\item{colors}{character vector, default: "default", this gives you:
c("white", "yellow2", "yellow3", "lightblue", "blue", "navy"),
do "high" for more high contrasts, or specify your own colors.}

\item{addFracPlot}{Add margin histogram plot on top of heatmap with
fractions per positions}

\item{location}{a character, default "start site", will make xlabel of heatmap be
Position relative to "start site" or alternative given.}

\item{shifting}{a character, default c("5prime", "3prime"), can also be
NULL (no shifting of reads). If NULL, will use first index of 'upstream'
and 'downstream' argument.}

\item{skip.last}{skip top(highest) read length, default FALSE}

\item{plot.ext}{a character, default ".pdf", alternative ".png"}

\item{plot.together}{logical (default: FALSE), plot all in 1 plot (if TRUE)}

\item{title}{a character, default NULL (no title),
what is the top title of plot?}

\item{scale_x}{numeric, how should the width of the single plots be scaled,
bigger the number, the bigger the plot}

\item{scale_y}{numeric, how should the height of the plots be scaled,
bigger the number, the bigger the plot}

\item{gradient.max}{numeric or character, default: "default", which is:
\code{max(coverage$score)}, the max coverage over all readlengths.
 If you want all plots to use same reference point
for max scaling, then first detect this point, look at max in plot etc,
and use that value, to get all plots to have same max point.}

\item{BPPARAM}{a core param, default: single thread: \code{BiocParallel::SerialParam()}.
Set to \code{BiocParallel::bpparam()} to use multicore. Be aware, this uses a lot of
extra ram (40GB+) for larger human samples!}
}
\value{
invisible(NULL), plots are saved
}
\description{
Coverage heatmap of multiple libraries
}
\seealso{
Other heatmaps: 
\code{\link{coverageHeatMap}()},
\code{\link{heatMapRegion}()},
\code{\link{heatMap_single}()}
}
\concept{heatmaps}
\keyword{internal}
