% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/txdbHelpers.R
\name{loadRegion}
\alias{loadRegion}
\title{Load transcript region}
\usage{
loadRegion(
  txdb,
  part = "tx",
  names.keep = NULL,
  by = "tx",
  skip.optimized = FALSE
)
}
\arguments{
\item{txdb}{a TxDb object, ORFik experiment object or a path to one of:
(.gtf ,.gff, .gff2, .gff2, .db or .sqlite),
Only in the loadRegion function: if it is a GRangesList, it will return it self.}

\item{part}{a character, one of: tx, ncRNA, mrna, leader, cds, trailer, intron,
NOTE: difference between tx and mrna is that tx are all transcripts, while
mrna are all transcripts with a cds, respectivly ncRNA are all tx without a cds.}

\item{names.keep}{a character vector of subset of names to keep. Example:
loadRegions(txdb, names = "ENST1000005"), will return only that transcript.
Remember if you set by to "gene", then this list must be with gene names.}

\item{by}{a character, default "tx" Either "tx" or "gene". What names to
output region by, the transcript name "tx" or gene names "gene".
NOTE: this is not the same as cdsBy(txdb, by = "gene"), cdsBy would then
only give 1 cds per Gene, loadRegion gives all isoforms, but with gene names.}

\item{skip.optimized}{logical, default FALSE. If TRUE, will not search for optimized
rds files to load created from ORFik::makeTxdbFromGenome(..., optimize = TRUE). The
optimized files are ~ 100x faster to load for human genome.}
}
\value{
a GRangesList of region
}
\description{
Usefull to simplify loading of standard regions, like cds' and leaders.
Adds another safety in that seqlevels will be set
}
\details{
Load as GRangesList if input is not already GRangesList.
}
\examples{
# GTF file is slow, but possible to use
gtf <- system.file("extdata", "hg19_knownGene_sample.sqlite",
                        package = "GenomicFeatures")
txdb <- loadTxdb(gtf)
loadRegion(txdb, "cds")
loadRegion(txdb, "intron")
# Use txdb from experiment
df <- ORFik.template.experiment()
txdb <- loadTxdb(df)
loadRegion(txdb, "leaders")
# Use ORFik experiment directly
loadRegion(df, "mrna")
}
