% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment_IO.R
\name{read.experiment}
\alias{read.experiment}
\title{Read ORFik \code{\link{experiment}}}
\usage{
read.experiment(
  file,
  in.dir = ORFik::config()["exp"],
  validate = TRUE,
  output.env = .GlobalEnv
)
}
\arguments{
\item{file}{relative path to a ORFik experiment. That is a .csv file following
ORFik experiment style ("," as seperator).
, or a template data.frame from \code{\link{create.experiment}}. Can
also be full path to file, then in.dir argument is ignored.}

\item{in.dir}{Directory to load experiment csv file from, default:
\code{ORFik::config()["exp"]}, which has default "~/Bio_data/ORFik_experiments/"\cr
Set to NULL if you don't want to save it to disc.
Does not apply if file argument is not a path (can also be a data.frame).
Also does not apply if file argument was given as full path.}

\item{validate}{logical, default TRUE. Abort if any library files does not exist.
Do not set this to FALSE, unless you know what you are doing!}

\item{output.env}{an environment, default .GlobalEnv. Which environment
should ORFik output libraries to (if this is done),
can be updated later with \code{envExp(df) <- new.env()}.}
}
\value{
an ORFik \code{\link{experiment}}
}
\description{
Read in runs / samples from an experiment as a single R object.
To read an ORFik experiment, you must of course make one first.
See \code{\link{create.experiment}}
The file must be csv and be a valid ORFik experiment
}
\examples{
# From file
\dontrun{
# Read from file
df <- read.experiment(filepath) # <- valid ORFik .csv file
}
## Read from (create.experiment() template)
df <- ORFik.template.experiment()

## To save it, do:
# save.experiment(df, file = "path/to/save/experiment")
## You can then do:
# read.experiment("path/to/save/experiment")
# or (identical):
# read.experiment("experiment", in.dir = "path/to/save/")
}
\seealso{
Other ORFik_experiment: 
\code{\link{ORFik.template.experiment}()},
\code{\link{ORFik.template.experiment.zf}()},
\code{\link{bamVarName}()},
\code{\link{create.experiment}()},
\code{\link{experiment-class}},
\code{\link{filepath}()},
\code{\link{libraryTypes}()},
\code{\link{organism,experiment-method}},
\code{\link{outputLibs}()},
\code{\link{save.experiment}()},
\code{\link{validateExperiments}()}
}
\concept{ORFik_experiment}
