% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift_footprints.R
\name{template_shift_table}
\alias{template_shift_table}
\title{Make template for shift table of experiment}
\usage{
template_shift_table(df, accepted.lengths = 26:34)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}}

\item{accepted.lengths}{accepted read lengths, default 26:34, usually ribo-seq
is strongest between 27:32.}
}
\value{
a list with names of elements as file path to the ofst,
the data.table elements 2 columns fraction: read length and offset_start,
the shifts in negative coordinates.
}
\description{
Must have ofst files already created!
}
\examples{
df <- ORFik:::ORFik.template.experiment()
template_shift_table(df)
}
