% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_positions.R
\name{upstreamFromPerGroup}
\alias{upstreamFromPerGroup}
\title{Get rest of objects upstream (inclusive)}
\usage{
upstreamFromPerGroup(tx, upstreamFrom)
}
\arguments{
\item{tx}{a \code{\link{GRangesList}},
usually of Transcripts to be changed}

\item{upstreamFrom}{a vector of integers, for each group in tx, where
is the new start point of first valid exon.}
}
\value{
a GRangesList of upstream part
}
\description{
Per group get the part upstream of position.
upstreamFromPerGroup(tx, stopSites(fiveUTRs, asGR = TRUE))
will return the  5' utrs per transcript as GRangesList,
usually used for interesting
parts of the transcripts.
}
\details{
If you don't want to include the points given in the region,
use \code{\link{upstreamOfPerGroup}}
}
\seealso{
Other GRanges: 
\code{\link{assignFirstExonsStartSite}()},
\code{\link{assignLastExonsStopSite}()},
\code{\link{downstreamFromPerGroup}()},
\code{\link{downstreamOfPerGroup}()},
\code{\link{upstreamOfPerGroup}()}
}
\concept{GRanges}
\keyword{internal}
