% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go.R
\name{go_annot_download}
\alias{go_annot_download}
\title{Gene annotations from Gene Ontology}
\usage{
go_annot_download(organism = "human", aspects = c("C", "F", "P"), slim = NULL)
}
\arguments{
\item{organism}{Character: either "chicken", "cow", "dog", "human", "pig"
or "uniprot_all".}

\item{aspects}{Character vector with some of the following elements:
"C" (cellular component), "F" (molecular function) and "P" (biological
process). Gene Ontology is three separate ontologies called as three
aspects. By this parameter you can control which aspects to include
in the output.}

\item{slim}{Character: if not \code{NULL}, the name of a GOsubset (slim).
instead of the full GO annotation, the slim annotation will be
returned. See details at \code{\link{go_annot_slim}}. If \code{TRUE},
the "generic" slim will be used.}
}
\value{
A tibble (data frame) of annotations as it is provided by the
    database
}
\description{
Gene Ontology is an ontology of gene subcellular localizations, molecular
functions and involvement in biological processes. Gene products across
many organisms are annotated with the ontology terms. This function
downloads the gene-ontology term associations for certain model organisms
or all organisms. For a description of the columns see
\url{http://geneontology.org/docs/go-annotation-file-gaf-format-2.2/}.
}
\examples{
goa_data <- go_annot_download()
goa_data
# # A tibble: 606,840 x 17
#    db       db_object_id db_object_symbol qualifier go_id   db_ref
#    <fct>    <chr>        <chr>            <fct>     <chr>   <chr>
#  1 UniProt. A0A024RBG1   NUDT4B           NA        GO:000. GO_REF:00.
#  2 UniProt. A0A024RBG1   NUDT4B           NA        GO:000. GO_REF:00.
#  3 UniProt. A0A024RBG1   NUDT4B           NA        GO:004. GO_REF:00.
#  4 UniProt. A0A024RBG1   NUDT4B           NA        GO:005. GO_REF:00.
#  5 UniProt. A0A024RBG1   NUDT4B           NA        GO:005. GO_REF:00.
# # . with 606,830 more rows, and 11 more variables:
# #   evidence_code <fct>, with_or_from <chr>, aspect <fct>,
# #   db_object_name <chr>, db_object_synonym <chr>,
# #   db_object_type <fct>, taxon <fct>, date <date>,
# #   assigned_by <fct>, annotation_extension <chr>,
# #   gene_product_from_id <chr>

}
