% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_mapping.R
\name{is_uniprot}
\alias{is_uniprot}
\title{Looks like a UniProt ID?}
\usage{
is_uniprot(identifiers)
}
\arguments{
\item{identifiers}{Character: one or more identifiers (typically a single
string, a vector or a data frame column).}
}
\value{
Logical: true if all elements in the input (except NAs) looks like
    valid UniProt IDs. If the input is not a character vector, `FALSE`
    is returned.
}
\description{
This function checks only the format of the IDs, no guarantee that these
IDs exist in UniProt.
}
\examples{
is_uniprot(all_uniprot_acs())
# [1] TRUE
is_uniprot("P00533")
# [1] TRUE
is_uniprot("pizza")
# [1] FALSE

}
