% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keggrest.R
\name{kegg_rm_prefix}
\alias{kegg_rm_prefix}
\title{Remove prefix from KEGG foreign database identifiers}
\usage{
kegg_rm_prefix(data, ..., .to_names = TRUE)
}
\arguments{
\item{data}{A data frame (tibble) with identifier column(s).}

\item{...}{Columns where the prefixes should be removed, as a tidyselect
selection. If empty, \code{everything()} is used to select all columns.}

\item{.to_names}{Logical: if \code{TRUE}, the column names will be
updated to reflect the removed prefixes.}
}
\value{
A data frame (tibble) with the prefixes removed.
}
\description{
Remove prefix from KEGG foreign database identifiers
}
\examples{
kegg_rm_prefix(kegg_conv("ncbi-geneid", "hsa"))

}
