% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nichenet.R
\name{nichenet_lr_network}
\alias{nichenet_lr_network}
\title{Builds a NicheNet ligand-receptor network}
\usage{
nichenet_lr_network(
  omnipath = list(),
  guide2pharma = list(),
  ramilowski = list(),
  only_omnipath = FALSE,
  quality_filter_param = list()
)
}
\arguments{
\item{omnipath}{List with paramaters to be passed to
\code{\link{nichenet_lr_network_omnipath}}.}

\item{guide2pharma}{List with paramaters to be passed to
\code{\link{nichenet_lr_network_guide2pharma}}.}

\item{ramilowski}{List with paramaters to be passed to
\code{\link{nichenet_lr_network_ramilowski}}.}

\item{only_omnipath}{Logical: a shortcut to use only OmniPath as network
resource.}

\item{quality_filter_param}{Arguments for \code{
\link{filter_intercell_network}} (quality filtering of the OmniPath
ligand-receptor network). It is recommended to check these parameters
and apply some quality filtering. The defaults already ensure certain
filtering, but you might want more relaxed or stringent options.}
}
\value{
A network data frame (tibble) with ligand-receptor interactions
    suitable for use with NicheNet.
}
\description{
Builds ligand-receptor network prior knowledge for NicheNet using multiple
resources.
}
\examples{
# load everything with the default parameters:
lr_network <- nichenet_lr_network()

# don't use Ramilowski:
lr_network <- nichenet_lr_network(ramilowski = NULL)

# use only OmniPath:
lr_network_omnipath <- nichenet_lr_network(only_omnipath = TRUE)

}
\seealso{
\itemize{
    \item{\code{\link{nichenet_lr_network_omnipath}}}
    \item{\code{\link{nichenet_lr_network_guide2pharma}}}
    \item{\code{\link{nichenet_lr_network_ramilowski}}}
    \item{\code{\link{filter_intercell_network}}}
}
}
