% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra_attrs.R
\name{filter_extra_attrs}
\alias{filter_extra_attrs}
\title{Filter interactions by extra attribute values}
\usage{
filter_extra_attrs(data, ..., na_ok = TRUE)
}
\arguments{
\item{data}{An interaction data frame with \emph{extra_attrs} column.}

\item{...}{Extra attribute names and values. The contents of the extra
attribute \emph{name} for each record will be checked against the
values provided. The check by default is a set intersection: if any
element is common between the user provided values and the values of
the extra attribute for the record, the record will be matched.
Alternatively, any value can be a custom function which accepts
the value of the extra attribute and returns a single logical
value. Finally, if the extra attribute name starts with a dot,
the result of the check will be negated.}

\item{na_ok}{Logical: keep the records which do not have the extra
attribute. Typically these are the records which are not from the
resource providing the extra attribute.}
}
\value{
The input data frame with records removed according to the
    filtering criteria.
}
\description{
Filter interactions by extra attribute values
}
\examples{
cl <- post_translational(
    resources = "Cellinker",
    fields = "extra_attrs"
)
# Only cell adhesion interactions from Cellinker
filter_extra_attrs(cl, Cellinker_type = "Cell adhesion")

op <- omnipath(fields = "extra_attrs")
# Any mechanism except phosphorylation
filter_extra_attrs(op, .SIGNOR_mechanism = "phosphorylation")

}
\seealso{
\itemize{
    \item{\code{\link{extra_attrs}}}
    \item{\code{\link{has_extra_attrs}}}
    \item{\code{\link{extra_attrs_to_cols}}}
    \item{\code{\link{with_extra_attrs}}}
    \item{\code{\link{extra_attr_values}}}
}
}
