% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obo.R
\name{obo_parser}
\alias{obo_parser}
\title{Generic OBO parser}
\usage{
obo_parser(
  path,
  relations = c("is_a", "part_of", "occurs_in", "regulates", "positively_regulates",
    "negatively_regulates"),
  shorten_namespace = TRUE,
  tables = TRUE
)
}
\arguments{
\item{path}{Path to the OBO file.}

\item{relations}{Character vector: process only these relations.}

\item{shorten_namespace}{Logical: shorten the namespace to a single
letter code (as usual for Gene Ontology, e.g. cellular_component =
"C").}

\item{tables}{Logical: return data frames (tibbles) instead of nested
lists.}
}
\value{
A list with the following elements: 1) "names" a list with
    terms as names and names as values; 2) "namespaces" a list with
    terms as names and namespaces as values; 3) "relations" a list with
    relations between terms: terms are keys, values are lists with
    relations as names and character vectors of related terms as
    values; 4) "subsets" a list with terms as keys and character
    vectors of subset names as values (or \code{NULL} if the term
    does not belong to any subset); 5) "obsolete" character vector
    with all the terms labeled as obsolete. If the \code{tables}
    parameter is \code{TRUE}, "names", "namespaces", "relations"
    and "subsets" will be data frames (tibbles).
}
\description{
Reads the contents of an OBO file and processes it into data frames or
a list based data structure.
}
\examples{
goslim_url <-
    "http://current.geneontology.org/ontology/subsets/goslim_generic.obo"
path <- tempfile()
curl::curl_fetch_disk(goslim_url, path)
obo <- obo_parser(path, tables = FALSE)
unlink(path)
names(obo)
# [1] "names"      "namespaces" "relations"  "subsets"    "obsolete"
head(obo$relations, n = 2)
# $`GO:0000001`
# $`GO:0000001`$is_a
# [1] "GO:0048308" "GO:0048311"
#
# $`GO:0000002`
# $`GO:0000002`$is_a
# [1] "GO:0007005"

}
\seealso{
\itemize{
    \item{\code{\link{relations_list_to_table}}}
    \item{\code{\link{relations_table_to_list}}}
    \item{\code{\link{swap_relations}}}
}
}
