% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preppi.R
\name{preppi_filter}
\alias{preppi_filter}
\title{Filter PrePPI interactions by scores}
\usage{
preppi_filter(data, ..., .op = "&")
}
\arguments{
\item{data}{A data frame of PrePPI interactions as provided by
\code{\link{preppi_download}}.}

\item{...}{Minimum values for the scores. The available scores are:
str, protpep, str_max, red, ort, phy, coexp, go, total, exp and final.
See more about the scores at \code{\link{preppi_download}}.}

\item{.op}{The operator to combine the scores with: either \code{'&'} or
\code{'|'}. With the former, only records where all scores are above
the threshold will be kept; with the latter, records where at least
one score is above its threshold will be kept.}
}
\value{
The input data frame (tibble) filtered by the score thresholds.
}
\description{
Filter PrePPI interactions by scores
}
\examples{
preppi <- preppi_download()
preppi_filtered <- preppi_filter(preppi, red = 10, str = 4.5, ort = 1)
nrow(preppi_filtered)
# [1] 8443

}
\seealso{
\code{\link{preppi_download}}
}
