% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/static.R
\name{static_table}
\alias{static_table}
\title{Retrieve a static table from OmniPath}
\usage{
static_table(
  query,
  resource,
  organism = 9606L,
  strict_evidences = TRUE,
  wide = TRUE,
  dorothea_levels = c("A", "B", "C")
)
}
\arguments{
\item{query}{Character: a query type such as "annotations" or
"interactions".}

\item{resource}{Character: name of the resource or dataset, such as
"CollecTRI" or "PROGENy".}

\item{organism}{Integer: NCBI Taxonomy of the organism: 9606 for human,
10090 for mouse and 10116 for rat.}

\item{strict_evidences}{Logical: restrict the evidences to the queried
datasets and resources. If set to FALSE, the directions and effect signs
and references might be based on other datasets and resources.}

\item{wide}{Convert the annotation table to wide format, which
corresponds more or less to the original resource. If the data comes
from more than one resource a list of wide tables will be returned.
See examples at \code{\link{pivot_annotations}}.}

\item{dorothea_levels}{Vector detailing the confidence levels of the
interactions to be downloaded. In dorothea, every TF-target interaction
has a confidence score ranging from A to E, being A the most reliable
interactions.
By default here we take A, B and C level interactions
(\code{c("A", "B", "C")}).
It is to note that E interactions are not available in OmnipathR.}
}
\value{
A data frame (tibble) with the requested resource.
}
\description{
A few resources and datasets are available also as plain TSV files and
can be accessed without TLS. The purpose of these tables is to make the
most often used OmniPath data available on computers with configuration
issues. These tables are not the recommended way to access OmniPath
data, and a warning is issued each time they are accessed.
}
\examples{
static_table("annotations", "PROGENy")

}
\seealso{
\code{\link{static_tables}}
}
