% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplot.R
\name{biplot}
\alias{biplot}
\title{Draw a bi-plot, comparing 2 selected principal components / eigenvectors.}
\usage{
biplot(
  pcaobj,
  x = "PC1",
  y = "PC2",
  showLoadings = FALSE,
  ntopLoadings = 5,
  showLoadingsNames = if (showLoadings) TRUE else FALSE,
  colLoadingsNames = "black",
  sizeLoadingsNames = 3,
  boxedLoadingsNames = TRUE,
  fillBoxedLoadings = alpha("white", 1/4),
  drawConnectorsLoadings = TRUE,
  widthConnectorsLoadings = 0.5,
  colConnectorsLoadings = "grey50",
  lengthLoadingsArrowsFactor = 1.5,
  colLoadingsArrows = "black",
  widthLoadingsArrows = 0.5,
  alphaLoadingsArrow = 1,
  colby = NULL,
  colkey = NULL,
  colLegendTitle = if (!is.null(colby)) colby else NULL,
  singlecol = NULL,
  shape = NULL,
  shapekey = NULL,
  shapeLegendTitle = if (!is.null(shape)) shape else NULL,
  pointSize = 3,
  legendPosition = "none",
  legendLabSize = 12,
  legendTitleSize = 14,
  legendIconSize = 5,
  encircle = FALSE,
  encircleFill = TRUE,
  encircleFillKey = NULL,
  encircleAlpha = 1/4,
  encircleLineSize = 0.25,
  encircleLineCol = NULL,
  ellipse = FALSE,
  ellipseType = "t",
  ellipseLevel = 0.95,
  ellipseSegments = 51,
  ellipseFill = TRUE,
  ellipseFillKey = NULL,
  ellipseAlpha = 1/4,
  ellipseLineSize = 0.25,
  ellipseLineCol = NULL,
  xlim = if (showLoadings || ellipse) c(min(pcaobj$rotated[, x]) -
    abs((min(pcaobj$rotated[, x])/100) * 35), max(pcaobj$rotated[, x]) +
    abs((min(pcaobj$rotated[, x])/100) * 35)) else c(min(pcaobj$rotated[, x]) -
    abs((min(pcaobj$rotated[, x])/100) * 10), max(pcaobj$rotated[, x]) +
    abs((min(pcaobj$rotated[, x])/100) * 10)),
  ylim = if (showLoadings || ellipse) c(min(pcaobj$rotated[, y]) -
    abs((min(pcaobj$rotated[, y])/100) * 35), max(pcaobj$rotated[, y]) +
    abs((min(pcaobj$rotated[, y])/100) * 35)) else c(min(pcaobj$rotated[, y]) -
    abs((min(pcaobj$rotated[, y])/100) * 10), max(pcaobj$rotated[, y]) +
    abs((min(pcaobj$rotated[, y])/100) * 10)),
  lab = rownames(pcaobj$metadata),
  labSize = 3,
  boxedLabels = FALSE,
  selectLab = NULL,
  drawConnectors = TRUE,
  widthConnectors = 0.5,
  colConnectors = "grey50",
  max.overlaps = 15,
  maxoverlapsConnectors = NULL,
  min.segment.length = 0,
  directionConnectors = "both",
  xlab = paste0(x, ", ", round(pcaobj$variance[x], digits = 2), "\% variation"),
  xlabAngle = 0,
  xlabhjust = 0.5,
  xlabvjust = 0.5,
  ylab = paste0(y, ", ", round(pcaobj$variance[y], digits = 2), "\% variation"),
  ylabAngle = 0,
  ylabhjust = 0.5,
  ylabvjust = 0.5,
  axisLabSize = 16,
  title = "",
  subtitle = "",
  caption = "",
  titleLabSize = 16,
  subtitleLabSize = 12,
  captionLabSize = 12,
  hline = NULL,
  hlineType = "longdash",
  hlineCol = "black",
  hlineWidth = 0.4,
  vline = NULL,
  vlineType = "longdash",
  vlineCol = "black",
  vlineWidth = 0.4,
  gridlines.major = TRUE,
  gridlines.minor = TRUE,
  borderWidth = 0.8,
  borderColour = "black",
  returnPlot = TRUE
)
}
\arguments{
\item{pcaobj}{Object of class 'pca' created by pca().}

\item{x}{A principal component to plot on x-axis. All principal component
names are stored in pcaobj$label.}

\item{y}{A principal component to plot on y-axis. All principal component
names are stored in pcaobj$label.}

\item{showLoadings}{Logical, indicating whether or not to overlay
variable loadings.}

\item{ntopLoadings}{If showLoadings == TRUE, select this many variables
based on absolute ordered variable loading for each PC in the biplot.
As a result of looking across 2 PCs, it can occur whereby greater than
this number are actually displayed.}

\item{showLoadingsNames}{Logical, indicating to show variable loadings names
or not.}

\item{colLoadingsNames}{If 'showLoadings == TRUE', colour of text labels.}

\item{sizeLoadingsNames}{If 'showLoadings == TRUE', size of text labels.}

\item{boxedLoadingsNames}{Logical, if 'showLoadings == TRUE', draw text
labels in boxes.}

\item{fillBoxedLoadings}{When 'boxedLoadingsNames == TRUE', this controls
the background fill of the boxes. To control both the fill and
transparency, user can specify a value of the form
'alpha(<colour>, <alpha>)'.}

\item{drawConnectorsLoadings}{If 'showLoadings == TRUE', draw line connectors
to the variable loadings arrows in order to fit more labels in the plot
space.}

\item{widthConnectorsLoadings}{If 'showLoadings == TRUE', width of the line
connectors drawn to the variable loadings arrows.}

\item{colConnectorsLoadings}{If 'showLoadings == TRUE', colour of the line
connectors drawn to the variable loadings arrows.}

\item{lengthLoadingsArrowsFactor}{If 'showLoadings == TRUE', multiply the
internally-determined length of the variable loadings arrows by this
factor.}

\item{colLoadingsArrows}{If showLoadings == TRUE, colour of the variable
loadings arrows.}

\item{widthLoadingsArrows}{If showLoadings == TRUE, width of the variable
loadings arrows.}

\item{alphaLoadingsArrow}{If showLoadings == TRUE, colour transparency of
the variable loadings arrows.}

\item{colby}{If NULL, all points will be coloured differently. If not NULL,
value is assumed to be a column name in pcaobj$metadata relating to some
grouping/categorical variable.}

\item{colkey}{Vector of name-value pairs relating to value passed to 'col',
e.g., c(A='forestgreen', B='gold').}

\item{colLegendTitle}{Title of the legend for the variable specified
by 'colby'.}

\item{singlecol}{If specified, all points will be shaded by this colour.
Overrides 'col'.}

\item{shape}{If NULL, all points will be have the same shape. If not NULL,
value is assumed to be a column name in pcaobj$metadata relating to some
grouping/categorical variable.}

\item{shapekey}{Vector of name-value pairs relating to value passed to
'shape', e.g., c(A=10, B=21).}

\item{shapeLegendTitle}{Title of the legend for the variable specified
by 'shape'.}

\item{pointSize}{Size of plotted points.}

\item{legendPosition}{Position of legend ('top', 'bottom', 'left', 'right',
'none').}

\item{legendLabSize}{Size of plot legend text.}

\item{legendTitleSize}{Size of plot legend title text.}

\item{legendIconSize}{Size of plot legend icons / symbols.}

\item{encircle}{Logical, indicating whether to draw a polygon around
the groups specified by 'colby'.}

\item{encircleFill}{Logical, if 'encircle == TRUE', this determines
whether to fill the encircled region or not.}

\item{encircleFillKey}{Vector of name-value pairs relating to value passed to
'encircleFill', e.g., c(A='forestgreen', B='gold'). If NULL, the fill
is controlled by whatever has already been used for 'colby' / 'colkey'.}

\item{encircleAlpha}{Alpha for purposes of controlling colour transparency of
the encircled region. Used when 'encircle == TRUE'.}

\item{encircleLineSize}{Line width of the encircled line when
'encircle == TRUE'.}

\item{encircleLineCol}{Colour of the encircled line when
'encircle == TRUE'.}

\item{ellipse}{Logical, indicating whether to draw a data ellipse around
the groups specified by 'colby'.}

\item{ellipseType}{[paraphrased from
https://ggplot2.tidyverse.org/reference/stat_ellipse.html]
The type of ellipse. "t" assumes a multivariate t-distribution, while
"norm" assumes a multivariate normal distribution. "euclid" draws a circle with
the radius equal to level, representing the euclidean distance from the center.
This ellipse probably won't appear circular unless coord_fixed() is applied.}

\item{ellipseLevel}{[paraphrased from
https://ggplot2.tidyverse.org/reference/stat_ellipse.html]
The level at which to draw an ellipse, or, if ellipseType="euclid", the radius of the circle to be drawn.}

\item{ellipseSegments}{[from
https://ggplot2.tidyverse.org/reference/stat_ellipse.html]
The number of segments to be used in drawing the ellipse.}

\item{ellipseFill}{Logical, if 'ellipse == TRUE', this determines
whether to fill the region or not.}

\item{ellipseFillKey}{Vector of name-value pairs relating to value passed to
'ellipseFill', e.g., c(A='forestgreen', B='gold'). If NULL, the fill
is controlled by whatever has already been used for 'colby' / 'colkey'.}

\item{ellipseAlpha}{Alpha for purposes of controlling colour transparency of
the ellipse region. Used when 'ellipse == TRUE'.}

\item{ellipseLineSize}{Line width of the ellipse line when 'ellipse == TRUE'.}

\item{ellipseLineCol}{Colour of the ellipse line when 'ellipse == TRUE'.}

\item{xlim}{Limits of the x-axis.}

\item{ylim}{Limits of the y-axis.}

\item{lab}{A vector containing labels to add to the plot.}

\item{labSize}{Size of labels.}

\item{boxedLabels}{Logical, draw text labels in boxes.}

\item{selectLab}{A vector containing a subset of lab to plot.}

\item{drawConnectors}{Logical, indicating whether or not to connect plot
labels to their corresponding points by line connectors.}

\item{widthConnectors}{Line width of connectors.}

\item{colConnectors}{Line colour of connectors.}

\item{max.overlaps}{Equivalent of max.overlaps in ggrepel. Set to
'Inf' to always display all labels when drawConnectors = TRUE.}

\item{maxoverlapsConnectors}{See max.overlaps.}

\item{min.segment.length}{When drawConnectors = TRUE, specifies the minimum
length of the connector line segments.}

\item{directionConnectors}{direction in which to draw connectors.
'both', 'x', or 'y'.}

\item{xlab}{Label for x-axis.}

\item{xlabAngle}{Rotation angle of x-axis labels.}

\item{xlabhjust}{Horizontal adjustment of x-axis labels.}

\item{xlabvjust}{Vertical adjustment of x-axis labels.}

\item{ylab}{Label for y-axis.}

\item{ylabAngle}{Rotation angle of y-axis labels.}

\item{ylabhjust}{Horizontal adjustment of y-axis labels.}

\item{ylabvjust}{Vertical adjustment of y-axis labels.}

\item{axisLabSize}{Size of x- and y-axis labels.}

\item{title}{Plot title.}

\item{subtitle}{Plot subtitle.}

\item{caption}{Plot caption.}

\item{titleLabSize}{Size of plot title.}

\item{subtitleLabSize}{Size of plot subtitle.}

\item{captionLabSize}{Size of plot caption.}

\item{hline}{Draw one or more horizontal lines passing through this/these
values on y-axis. For single values, only a single numerical value is
necessary. For multiple lines, pass these as a vector, e.g., c(60,90).}

\item{hlineType}{Line type for hline ('blank', 'solid', 'dashed', 'dotted',
'dotdash', 'longdash', 'twodash').}

\item{hlineCol}{Colour of hline.}

\item{hlineWidth}{Width of hline.}

\item{vline}{Draw one or more vertical lines passing through this/these
values on x-axis. For single values, only a single numerical value is
necessary. For multiple lines, pass these as a vector, e.g., c(60,90).}

\item{vlineType}{Line type for vline ('blank', 'solid', 'dashed', 'dotted',
'dotdash', 'longdash', 'twodash').}

\item{vlineCol}{Colour of vline.}

\item{vlineWidth}{Width of vline.}

\item{gridlines.major}{Logical, indicating whether or not to draw major
gridlines.}

\item{gridlines.minor}{Logical, indicating whether or not to draw minor
gridlines.}

\item{borderWidth}{Width of the border on the x and y axes.}

\item{borderColour}{Colour of the border on the x and y axes.}

\item{returnPlot}{Logical, indicating whether or not to return the plot
object.}
}
\value{
A \code{\link{ggplot2}} object.
}
\description{
Draw a bi-plot, comparing 2 selected principal components / eigenvectors.
}
\details{
Draw a bi-plot, comparing 2 selected principal components / eigenvectors.
}
\examples{
  options(scipen=10)
  options(digits=6)

  col <- 20
  row <- 20000
  mat1 <- matrix(
    rexp(col*row, rate = 0.1),
    ncol = col)
  rownames(mat1) <- paste0('gene', 1:nrow(mat1))
  colnames(mat1) <- paste0('sample', 1:ncol(mat1))

  mat2 <- matrix(
  rexp(col*row, rate = 0.1),
    ncol = col)
  rownames(mat2) <- paste0('gene', 1:nrow(mat2))
  colnames(mat2) <- paste0('sample', (ncol(mat1)+1):(ncol(mat1)+ncol(mat2)))

  mat <- cbind(mat1, mat2)

  metadata <- data.frame(row.names = colnames(mat))
  metadata$Group <- rep(NA, ncol(mat))
  metadata$Group[seq(1,40,2)] <- 'A'
  metadata$Group[seq(2,40,2)] <- 'B'
  metadata$CRP <- sample.int(100, size=ncol(mat), replace=TRUE)
  metadata$ESR <- sample.int(100, size=ncol(mat), replace=TRUE)

  p <- pca(mat, metadata = metadata, removeVar = 0.1)

  biplot(p)

  biplot(p, colby = 'Group', shape = 'Group')

  biplot(p, colby = 'Group', colkey = c(A = 'forestgreen', B = 'gold'),
    legendPosition = 'right')

  biplot(p, colby = 'Group', colkey = c(A='forestgreen', B='gold'),
    shape = 'Group', shapekey = c(A=10, B=21), legendPosition = 'bottom')

}
\author{
Kevin Blighe <kevin@clinicalbioinformatics.co.uk>
}
