% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotloadings.R
\name{plotloadings}
\alias{plotloadings}
\title{Plot the component loadings for selected principal components / eigenvectors and label variables driving variation along these.}
\usage{
plotloadings(
  pcaobj,
  components = getComponents(pcaobj, seq_len(5)),
  rangeRetain = 0.05,
  absolute = FALSE,
  col = c("gold", "white", "royalblue"),
  colMidpoint = 0,
  shape = 21,
  shapeSizeRange = c(10, 10),
  legendPosition = "top",
  legendLabSize = 10,
  legendIconSize = 3,
  xlim = NULL,
  ylim = NULL,
  labSize = 2,
  labhjust = 1.5,
  labvjust = 0,
  drawConnectors = TRUE,
  positionConnectors = "right",
  widthConnectors = 0.5,
  typeConnectors = "closed",
  endsConnectors = "first",
  lengthConnectors = unit(0.01, "npc"),
  colConnectors = "grey50",
  xlab = "Principal component",
  xlabAngle = 0,
  xlabhjust = 0.5,
  xlabvjust = 0.5,
  ylab = "Component loading",
  ylabAngle = 0,
  ylabhjust = 0.5,
  ylabvjust = 0.5,
  axisLabSize = 16,
  title = "",
  subtitle = "",
  caption = "",
  titleLabSize = 16,
  subtitleLabSize = 12,
  captionLabSize = 12,
  hline = c(0),
  hlineType = "longdash",
  hlineCol = "black",
  hlineWidth = 0.4,
  vline = NULL,
  vlineType = "longdash",
  vlineCol = "black",
  vlineWidth = 0.4,
  gridlines.major = TRUE,
  gridlines.minor = TRUE,
  borderWidth = 0.8,
  borderColour = "black",
  returnPlot = TRUE
)
}
\arguments{
\item{pcaobj}{Object of class 'pca' created by pca().}

\item{components}{The principal components to be included in the plot.}

\item{rangeRetain}{Cut-off value for retaining variables. The function
will look across each specified principal component and retain the variables
that fall within this top/bottom fraction of the loadings range.}

\item{absolute}{Logical, indicating whether or not to plot absolute loadings.}

\item{col}{Colours used for generation of fill gradient according to
loadings values. Can be 2 or 3 colours.}

\item{colMidpoint}{Mid-point (loading) for the colour range.}

\item{shape}{Shape of the plotted points.}

\item{shapeSizeRange}{Size range for the plotted points (min, max).}

\item{legendPosition}{Position of legend ('top', 'bottom', 'left', 'right',
'none').}

\item{legendLabSize}{Size of plot legend text.}

\item{legendIconSize}{Size of plot legend icons / symbols.}

\item{xlim}{Limits of the x-axis.}

\item{ylim}{Limits of the y-axis.}

\item{labSize}{Size of labels.}

\item{labhjust}{Horizontal adjustment of label.}

\item{labvjust}{Vertical adjustment of label.}

\item{drawConnectors}{Logical, indicating whether or not to connect plot
labels to their corresponding points by line connectors.}

\item{positionConnectors}{Position of the connectors and their labels with
respect to the plotted points ('left', 'right').}

\item{widthConnectors}{Line width of connectors.}

\item{typeConnectors}{Have the arrow head open or filled ('closed')?
('open', 'closed').}

\item{endsConnectors}{Which end of connectors to draw arrow head? ('last',
'first', 'both').}

\item{lengthConnectors}{Length of the connectors.}

\item{colConnectors}{Line colour of connectors.}

\item{xlab}{Label for x-axis.}

\item{xlabAngle}{Rotation angle of x-axis labels.}

\item{xlabhjust}{Horizontal adjustment of x-axis labels.}

\item{xlabvjust}{Vertical adjustment of x-axis labels.}

\item{ylab}{Label for y-axis.}

\item{ylabAngle}{Rotation angle of y-axis labels.}

\item{ylabhjust}{Horizontal adjustment of y-axis labels.}

\item{ylabvjust}{Vertical adjustment of y-axis labels.}

\item{axisLabSize}{Size of x- and y-axis labels.}

\item{title}{Plot title.}

\item{subtitle}{Plot subtitle.}

\item{caption}{Plot caption.}

\item{titleLabSize}{Size of plot title.}

\item{subtitleLabSize}{Size of plot subtitle.}

\item{captionLabSize}{Size of plot caption.}

\item{hline}{Draw one or more horizontal lines passing through this/these
values on y-axis. For single values, only a single numerical value is
necessary. For multiple lines, pass these as a vector, e.g., c(60,90).}

\item{hlineType}{Line type for hline ('blank', 'solid', 'dashed', 'dotted',
'dotdash', 'longdash', 'twodash').}

\item{hlineCol}{Colour of hline.}

\item{hlineWidth}{Width of hline.}

\item{vline}{Draw one or more vertical lines passing through this/these
values on x-axis. For single values, only a single numerical value is
necessary. For multiple lines, pass these as a vector, e.g., c(60,90).}

\item{vlineType}{Line type for vline ('blank', 'solid', 'dashed', 'dotted',
'dotdash', 'longdash', 'twodash').}

\item{vlineCol}{Colour of vline.}

\item{vlineWidth}{Width of vline.}

\item{gridlines.major}{Logical, indicating whether or not to draw major
gridlines.}

\item{gridlines.minor}{Logical, indicating whether or not to draw minor
gridlines.}

\item{borderWidth}{Width of the border on the x and y axes.}

\item{borderColour}{Colour of the border on the x and y axes.}

\item{returnPlot}{Logical, indicating whether or not to return the plot
object.}
}
\value{
A \code{\link{ggplot2}} object.
}
\description{
Plot the component loadings for selected principal components / eigenvectors and label variables driving variation along these.
}
\details{
Plot the component loadings for selected principal components / eigenvectors and label variables driving variation along these.
}
\examples{
  options(scipen=10)
  options(digits=6)

  col <- 20
  row <- 20000
  mat1 <- matrix(
    rexp(col*row, rate = 0.1),
    ncol = col)
  rownames(mat1) <- paste0('gene', 1:nrow(mat1))
  colnames(mat1) <- paste0('sample', 1:ncol(mat1))

  mat2 <- matrix(
    rexp(col*row, rate = 0.1),
    ncol = col)
  rownames(mat2) <- paste0('gene', 1:nrow(mat2))
  colnames(mat2) <- paste0('sample', (ncol(mat1)+1):(ncol(mat1)+ncol(mat2)))

  mat <- cbind(mat1, mat2)

  metadata <- data.frame(row.names = colnames(mat))
  metadata$Group <- rep(NA, ncol(mat))
  metadata$Group[seq(1,40,2)] <- 'A'
  metadata$Group[seq(2,40,2)] <- 'B'
  metadata$CRP <- sample.int(100, size=ncol(mat), replace=TRUE)
  metadata$ESR <- sample.int(100, size=ncol(mat), replace=TRUE)

  p <- pca(mat, metadata = metadata, removeVar = 0.1)

  plotloadings(p, drawConnectors = TRUE)

}
\author{
Kevin Blighe <kevin@clinicalbioinformatics.co.uk>
}
