% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PIUMA_assessTDA.R
\name{checkNetEntropy}
\alias{checkNetEntropy}
\title{Compute the Network Entropy}
\usage{
checkNetEntropy(outcome_vect)
}
\arguments{
\item{outcome_vect}{A vector containing the average outcome values for each
node
of a network.}
}
\value{
The network entropy using each node of a network.
}
\description{
This function computes the average of the entropies for
each node of a network.
}
\details{
The average of the entropies is related to the amount of information
stored in the network.
}
\examples{
# use example data:
set.seed(1)
entropy <- checkNetEntropy(round(runif(10),0))

}
\seealso{
\code{\link{makeTDAobj}},
\code{\link{dfToDistance}},
\code{\link{dfToProjection}},
\code{\link{mapperCore}},
\code{\link{jaccardMatrix}},
\code{\link{tdaDfEnrichment}}
}
\author{
Mattia Chiesa, Laura Ballarini, Luca Piacentini
}
