% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polytect_merge.R
\name{polytect_merge}
\alias{polytect_merge}
\title{Function for merging}
\usage{
polytect_merge(
  data,
  cluster_num,
  base_clust,
  lambdas = rep(2, 64 - log2(64)),
  coefs = rep(1, 6)
)
}
\arguments{
\item{data}{A matrix of fluorescence intensities in each channel. Each row represents each partitions, and each column each channel.}

\item{cluster_num}{The expected maximum number of clusters.}

\item{base_clust}{A list that contains partition labels given by initial clustering.}

\item{lambdas}{The penalty terms for the deviation from the expected cluster centers. Higher \code{lambdas} penalizes the deviation more.}

\item{coefs}{The coefficients to adjust for the expected cluster centers. The default is 1 which can be used for common assay designs and has
to be modified for special assays such as competing assays.}
}
\value{
A data frame containing the original fluorescence intensity and the cluster labels.
}
\description{
This function takes the clustering result as input. Users can first perform any clustering algorithm, then use this function. It
will return a data frame of fluorescence intensities and partition labels.
}
\examples{
data(HR)
dist_matrix <- dist(HR)
hc <- hclust(dist_matrix, method = "ward.D2")
hc_clusters <- cutree(hc, k = 6)
base_clust<-list()
base_clust$cluster<-hc_clusters
head(polytect_merge(HR, 4, base_clust))
}
