% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Annotations.R
\name{addAnnotationImage}
\alias{addAnnotationImage}
\title{Add Image Annotation}
\usage{
addAnnotationImage(
  url = NULL,
  x.pos = NULL,
  y.pos = NULL,
  angle = NULL,
  opacity = NULL,
  brightness = NULL,
  contrast = NULL,
  borderThickness = NULL,
  borderColor = NULL,
  borderOpacity = NULL,
  height = NULL,
  width = NULL,
  name = NULL,
  canvas = NULL,
  z.order = NULL,
  network = NULL,
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{url}{URL or path to image file. File paths can be absolute or relative
to current working directory. URLs must start with http:// or https://.}

\item{x.pos}{(optional) X position in pixels from left; default is center 
of current view}

\item{y.pos}{(optional) Y position in pixels from top; default is center 
of current view}

\item{angle}{(optional) Angle of text orientation; default is 0.0 
(horizontal)}

\item{opacity}{(optional) Opacity of fill color. Must be an integer between 
0 and 100; default is 100.}

\item{brightness}{(optional) Image brightness. Must be an integer between 
-100 and 100; default is 0}

\item{contrast}{(optional) Image contrast. Must be an integer between 
-100 and 100; default is 0}

\item{borderThickness}{(optional) Integer}

\item{borderColor}{(optional) Hexidecimal color; default is #000000 (black)}

\item{borderOpacity}{(optional) Integer between 0 and 100; default is 100.}

\item{height}{(optional) Height of image; default is based on text
height.}

\item{width}{(optional) Width of image; default is based on text
length.}

\item{name}{(optional) Name of annotation object; default is "Image"}

\item{canvas}{(optional) Canvas to display annotation, i.e., foreground 
(default) or background}

\item{z.order}{(optional) Arrangement order specified by number (larger
values are in front of smaller values); default is 0}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is 
http://localhost:1234 and the latest version of the CyREST API supported by
this version of RCy3.}
}
\value{
A named list of annotation properties, including UUID
}
\description{
Adds a Image annotation to a Cytoscape network view. The 
object will also be added to the Annotation Panel in the GUI.
}
\examples{
\donttest{
addAnnotationImage("image.png")
addAnnotationImage("/Users/janedoe/Desktop/image.png", 1000, 1000, name="I2")
addAnnotationImage("https://www.example.com/image.png", 1200, 1000, 30, 
    40, name="I3", canvas="background",z=4)
}
}
