% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dataformating.R
\name{getEdgesDataFrame}
\alias{getEdgesDataFrame}
\title{Create Edges \code{data.frame} from Adjacency matrix and properties}
\usage{
getEdgesDataFrame(A, eGlobal = NULL, eProp = NULL)
}
\arguments{
\item{A}{signed weighted adjacency matrix}

\item{eGlobal}{A \code{list} of properties for assigning all edges.
Default value is \code{NULL}}

\item{eProp}{A \code{data.frame} for assigning some nodes properties
Default value is \code{NULL}}
}
\value{
A \code{data.frame}
}
\description{
Create Edges \code{data.frame} from Adjacency matrix and properties
}
\examples{
v <- c(0, 0, 1, 1, 0,
       0, 0, 0, 0, 0,
      -1, 0, 0, 1, 0)
a <- matrix(v, 3, 5)
colnames(a) <- LETTERS[1:5]
rownames(a) <- LETTERS[1:3]
eGlobal <- list(color="#5555ff")
eProp <- data.frame(from=c('A','C'), to=c('B', 'A'), width=c(2,2))
getEdgesDataFrame(A=a, eGlobal=eGlobal, eProp=eProp)
}
\author{
Sylvain Gubian \email{DL.RSupport@pmi.com}
}

