% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rjmcmcMethodsIntern.R
\name{validatePlotNucleosomesParameters}
\alias{validatePlotNucleosomesParameters}
\title{Parameters validation for the \code{\link{plotNucleosomes}} function}
\usage{
validatePlotNucleosomesParameters(nucleosomePositions, reads, seqName, xlab,
  ylab, names)
}
\arguments{
\item{nucleosomePositions}{a \code{GRanges} or a \code{GRangesList}
containing the nucleosome positions for one or
multiples predictions obtained using the same reads. In presence of
only one prediction (with multiples nucleosome positions), a \code{GRanges}
is used. In presence of more thant one predictions (as example, before and
after post-treatment or results from different software), a
\code{GRangesList} with one entry per prediction is used.}

\item{reads}{a \code{GRanges} containing forward and
reverse reads. The \code{GRanges} should contain at least one read.}

\item{seqName}{a \code{character} string containing the label of the
chromosome, present in the \code{GRanges} object, that will be used. The
\code{NULL} value is accepted when only one seqname is
present in the \code{GRanges}; the only seqname present will be used.}

\item{xlab}{a \code{character} string containing the label of the x-axis.}

\item{ylab}{a \code{character} string containing the label of the y-axis.}

\item{names}{a \code{vector} of a \code{character} string containing the
label of each prediction set. The \code{vector} must be the same length of
the \code{nucleosomePositions} \code{list} or 1 in presence of a
\code{vector}.}
}
\value{
\code{0} indicating that all parameters validations have been
successful.
}
\description{
Validation of all parameters needed by the public
\code{\link{plotNucleosomes}} function.
}
\examples{

## Load GRanges dataset
data(reads_demo_01)

## Load RJMCMC result
data(RJMCMC_result)

## The function returns 0 when all parameters are valid
RJMCMCNucleosomes:::validatePlotNucleosomesParameters(nucleosomePositions =
RJMCMC_result$mu, reads = reads_demo_01, seqName = "chr_SYNTHETIC",
xlab = "position", ylab = "coverage", names = c("test"))

## The function raises an error when at least one paramater is not valid
#\dontrun{RJMCMCNucleosomes:::validatePlotNucleosomesParameters(
#nucleosomePositions = c("hi"), reads = reads,
#xlab = "position", ylab = "coverage", names = c("test"))}

#\dontrun{RJMCMCNucleosomes:::validatePlotNucleosomesParameters(
#nucleosomePositions = RJMCMC_result$mu, reads = reads_demo_01,
#seqName = "chr_SYNTHETIC", xlab = "position", ylab = "coverage",
#names = c("test_one", "test_false"))}

}
\author{
Astrid Deschenes, Pascal Belleau
}
\keyword{internal}
