% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\docType{methods}
\name{tnsKM,TNS-method}
\alias{tnsKM,TNS-method}
\alias{tnsKM}
\title{Kaplan-Meier analysis for TNS class objects}
\usage{
\S4method{tnsKM}{TNS}(
  tns,
  regs = NULL,
  sections = 1,
  undetermined.status = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{tns}{A \linkS4class{TNS} object, which must have passed GSEA2 analysis.}

\item{regs}{An optional string vector listing regulons to be tested.}

\item{sections}{A numeric value for sample stratification. The larger
the number, the more subdivisions will be created for the Kaplan-Meier 
analysis.}

\item{undetermined.status}{a logical value. If TRUE, regulons assigned as 
'undetermined' will form a group.}

\item{verbose}{A logical value specifying to display detailed messages 
(when verbose=TRUE) or not (when verbose=FALSE).}
}
\value{
Results from 'survfit' and 'survdiff', including log-rank statistics.
}
\description{
Creates survival curves and tests if there is a difference between 
curves using 'survfit' and 'survdiff' functions, respectivelly.
}
\examples{
# load survival data
data(survival.data, package = "RTNsurvival")

# load TNI-object
data(stni, package = "RTN")

stns <- tni2tnsPreprocess(stni, survivalData = survival.data, 
        keycovar = c('Grade','Age'), time = 1, event = 2)
stns <- tnsGSEA2(stns)
stns <- tnsKM(stns)
tnsGet(stns, "kmTable")

}
