% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\docType{methods}
\name{tnsPlotKmInteraction,TNS-method}
\alias{tnsPlotKmInteraction,TNS-method}
\alias{tnsPlotKmInteraction}
\title{Plot results from Kaplan-Meier analysis for dual regulons}
\usage{
\S4method{tnsPlotKmInteraction}{TNS}(
  tns,
  dualreg = NULL,
  fname = "kmInteraction",
  fpath = ".",
  xlab = "Months",
  ylab = "Survival probability",
  colorPalette = "bluered",
  width = 4,
  height = 4,
  plotpdf = FALSE
)
}
\arguments{
\item{tns}{A \linkS4class{TNS} object, which must have passed GSEA2 analysis.}

\item{dualreg}{A character string with the name of a dual regulon.}

\item{fname}{A string. The name of the file in which the plot will be saved}

\item{fpath}{A string. The path to the directory where the plot will be saved}

\item{xlab}{A string. The label for the x axis on the third panel. This should
be the measure of time shown in the survival data.frame after the last 
check-up.}

\item{ylab}{A string. The label for the y axis on the third panel}

\item{colorPalette}{A string, which can be 'redblue' or 'bluered'. 
Alternatively, it can be a vector of five colors or hex values.}

\item{width}{A numeric value. Represents the width of the plot.}

\item{height}{A numeric value. Represents the height of the plot.}

\item{plotpdf}{A logical value. If TRUE, the plot is saved as a pdf file. 
If false, it is plotted in the plotting area.}
}
\value{
A plot, showing a graphical analysis for the 'tnsKmInteraction' function.
}
\description{
Plot results from Kaplan-Meier analysis for dual regulons
}
\examples{
# load survival data
data(survival.data, package = "RTNsurvival")

# load TNI-object
data(stni, package = "RTN")

stns <- tni2tnsPreprocess(stni, survivalData = survival.data, 
keycovar = c('Grade','Age'), time = 1, event = 2)
stns <- tnsGSEA2(stns)

# KM analysis for dual regulons
# stns <- tnsKmInteraction(stns, stepFilter=FALSE)
# tnsPlotKmInteraction(stns, dualreg = "FOXM1~PTTG1")

}
