\name{DSpermute4GSEA}
\alias{DSpermute4GSEA}
\title{
Compute NB-statistics quantifying differential splicing on the permutation data set. 
}
\description{
This function is to calculate NB-statistics quantifying differential splicing for each gene on each permutation data set. 
The results will be used for GSEA run as DS background.
}
\usage{
DSpermute4GSEA(RCS, permuteMat)
}
\arguments{
  \item{RCS}{a ReadCountSet object after running \code{\link{exonTestability}}. }
  \item{permuteMat}{a permutation matrix generated by \code{\link{genpermuteMat}}. }

}
\note{
Please run \code{\link{exonTestability}} before run this function. 
}
\details{
Parallel running configuration: TODO 
}
\value{
A ReadCountSet object with slot permute_NBstat_gene updated. 
}
\references{
Xi Wang and Murray J. Cairns (2013). Gene Set Enrichment Analysis of RNA-Seq Data: Integrating Differential Expression and Splicing. BMC Bioinformatics, 14(Suppl 5):S16.
}
\author{
Xi Wang, xi.wang@newcastle.edu.au
}
\seealso{
\code{\link{exonTestability}},
\code{\link{genpermuteMat}},
\code{\link{DENBStatPermut4GSEA}},
\code{\link{DSpermutePval}}
}
\examples{
data(RCS_example, package="SeqGSEA")
permuteMat <- genpermuteMat(RCS_example, times=10)
RCS_example <- exonTestability(RCS_example)
RCS_example <- DSpermute4GSEA(RCS_example, permuteMat)
head(RCS_example@permute_NBstat_gene)
}
