% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygons.R
\name{readPolygonsMerfish}
\alias{readPolygonsMerfish}
\title{readPolygonsMerfish}
\usage{
readPolygonsMerfish(
  polygons,
  type = c("parquet", "HDF5"),
  keepMultiPol = TRUE,
  hdf5pattern = "hdf5",
  zLev = 3L,
  zcolumn = "ZIndex",
  geometry = "Geometry",
  verbose = FALSE
)
}
\arguments{
\item{polygons}{A character string specifying the folder containing the
polygon data files in case of HDF5, or a path to a parquet file (see `type`).}

\item{type}{A character string specifying the file type("HDF5" or "parquet").
Default is parquet.}

\item{keepMultiPol}{A logical value indicating whether to keep multipolygons.}

\item{hdf5pattern}{A character string specifying the pattern to match HDF5
files.}

\item{zLev}{An integer specifying the Z level to filter the data. Default is
`3L`.}

\item{zcolumn}{A character string specifying the column name for the Z index.}

\item{geometry}{A character string specifying the geometry column name.}

\item{verbose}{A logical value indicating whether to print additional
information.}
}
\value{
An `sf` object containing the MERFISH polygon data.
}
\description{
This function reads polygon data specific to MERFISH technology.
}
\examples{
example(readMerfishSPE)
polygons <- readPolygonsMerfish(metadata(spe)$polygons, type="parquet")
polygons
}
