% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/builds.R
\name{builds}
\alias{builds}
\alias{translateBuild}
\alias{correctBuild}
\alias{isCorrect}
\alias{extractBuild}
\alias{uniformBuilds}
\title{Utilities for working with \emph{HUMAN} genome builds}
\usage{
translateBuild(from, to = c("UCSC", "NCBI"))

correctBuild(build, style = c("UCSC", "NCBI"))

isCorrect(build, style = c("UCSC", "NCBI"))

extractBuild(string, build = c("UCSC", "NCBI"))

uniformBuilds(builds, cutoff = 0.2, na = c("", "NA"))
}
\arguments{
\item{from}{character() A vector of build versions typically from \code{genome()}
(e.g., "37"). The build vector must be homogenous (i.e.,
\code{length(unique(x)) == 1L}).}

\item{to}{character(1) The name of the desired build version (either "UCSC"
or "NCBI"; default: "UCSC")}

\item{build}{A vector of build version names (default UCSC, NCBI)}

\item{style}{character(1) The annotation style, either 'UCSC' or 'NCBI'}

\item{string}{A single character string}

\item{builds}{A character vector of builds}

\item{cutoff}{numeric(1L) An inclusive threshold tolerance value for missing
values and translating builds that are below the threshold}

\item{na}{character() The values to be considered as missing (default:
c("", "NA"))}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{translateBuild: A character vector of translated genome builds

extractBuild: A character string of the build information available

uniformBuilds: A character vector of builds where all builds are
    identical `identical(length(unique(build)), 1L)`

correctBuild: A character string of the 'corrected' build name

isCorrect: A logical indicating if the build is exactly as annotated
}\if{html}{\out{</div>}}
}
\description{
A few functions are available to search for build versions,
either from NCBI or UCSC.

\itemize{
\item \code{translateBuild}: translates between UCSC and NCBI build
versions
\item \code{extractBuild}: use grep patterns to find the first build
within the string input
\item \code{uniformBuilds}: replace build occurrences below a threshold
level of occurence with the alternative build
\item \code{correctBuild}: Ensure that the build annotation is correct
based on the NCBI/UCSC website. If not, use \code{translateBuild} with
the indicated 'style' input
\item \code{isCorrect}: Check to see if the build is exactly as annotated
}
}
\details{
The \code{correctBuild} function takes the input and ensures that
the style specified matches the input. Otherwise, it will
return the correct style for use with  \code{seqlevelsStyle}.
Currently, the function does not support patched builds
(e.g., 'GRCh38.p13') Build names are taken from the website:
\url{https://www.ncbi.nlm.nih.gov/assembly/GCF_000001405.26/}
}
\examples{

translateBuild("GRCh35", "UCSC")


correctBuild("grch38", "NCBI")
correctBuild("hg19", "NCBI")


isCorrect("GRCh38", "NCBI")

isCorrect("hg19", "UCSC")


extractBuild(
"SCENA_p_TCGAb29and30_SNP_N_GenomeWideSNP_6_G05_569110.nocnv_grch38.seg.txt"
)


buildvec <- rep(c("GRCh37", "hg19"), times = c(5, 1))
uniformBuilds(buildvec)

navec <- c(rep(c("GRCh37", "hg19"), times = c(5, 1)), "NA")
uniformBuilds(navec)

}
