% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TENxPeaks-class.R
\name{TENxPeaks}
\alias{TENxPeaks}
\title{Import 10x peak annotation files from 10x}
\usage{
TENxPeaks(resource, extension, ...)
}
\arguments{
\item{resource}{character(1) The path to the file}

\item{extension}{character(1) The file extension for the given resource. It
can usually be obtained from the file path. An override can be provided
especially for \code{ExperimentHub} resources where the file extension is
removed.}

\item{...}{Additional inputs to the low level class generator functions}
}
\value{
A \code{GRanges} class object of peak locations
}
\description{
This constructor function is designed to work with the files denoted with
"peak_annotation" in the file name. These are usually produced as tab
separated value files, i.e., \code{.tsv}.
}
\details{
The output class allows handling of peak data. It can be used in
conjunction with the \code{annotation} method on a \code{SingleCellExperiment} to add
peak information to the experiment. The ranged data is represented as a
\code{GRanges} class object.
}
\examples{

fi <- system.file(
    "extdata", "pbmc_granulocyte_sorted_3k_ex_atac_peak_annotation.tsv",
    package = "TENxIO", mustWork = TRUE
)
peak_file <- TENxPeaks(fi)
peak_anno <- import(peak_file)
peak_anno

example(TENxH5)

## Add peaks to an existing SCE
## First, import the SCE from an example H5 file
h5f <- system.file(
    "extdata", "pbmc_granulocyte_ff_bc_ex.h5",
    package = "TENxIO", mustWork = TRUE
)
con <- TENxH5(h5f)
sce <- import(con)
## auto-import peaks when using annotation<-
annotation(sce, name = "peak_annotation") <- peak_file
annotation(sce)

}
