% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocess.R
\name{model_fit}
\alias{model_fit}
\title{Refit and calculate derivative function}
\usage{
model_fit(norm_data, model, smoothed)
}
\arguments{
\item{norm_data}{data frame; the raw data set input}

\item{model}{fitted model containing fitted values}

\item{smoothed}{inform whether data already contains a smoothed model; Input
the column name of the smoothed data to override values of gam model
fitting. For example, existing "Fluorescence" column contains data
already smoothed, set \code{smoothed = "Flourescence"} to calculate
derivative function upon the called smoothed data.}
}
\value{
data frame; with calculated derivative columns
}
\description{
Model_fit calculates derivatives by refitting model onto data. Only runs
    on data of a single well.
}
\examples{
data("qPCR_data1")
test <- subset(qPCR_data1, Well.Position == "A01")
test <- normalize(test, fluo = 5, selected = c(
    "Well.Position", "Temperature",
    "Fluorescence", "Normalized"
))
gammodel <- model_gam(test, x = test$Temperature, y = test$Normalized)
model_fit(test, model = gammodel)
# if data come smoothed, run ...
model_fit(test, smoothed = "Fluorescence")

}
\seealso{
Other data_preprocess: 
\code{\link{model_boltzmann}()},
\code{\link{model_gam}()},
\code{\link{normalize}()},
\code{\link{remove_raw}()},
\code{\link{run_boltzmann}()},
\code{\link{screen}()},
\code{\link{view_model}()},
\code{\link{weed_raw}()}
}
\concept{data_preprocess}
