% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/methods-HMMList.R
\docType{class}
\name{HMMList-class}
\alias{HMMList-class}
\alias{show,HMMList-method}
\alias{unlist,HMMList-method}
\title{Class, constructor, and methods for representing HMM results from
multiple samples}
\usage{
\S4method{show}{HMMList}(object)

\S4method{unlist}{HMMList}(x, recursive = TRUE, use.names = TRUE)
}
\arguments{
\item{object}{a \code{HMMList} object}

\item{x}{a \code{HMMList} object}

\item{recursive}{logical;  currently ignored}

\item{use.names}{logical;  currently ignored}
}
\description{
Each element of the HMMList contains the genomic intervals of the
HMM segmentation (GRanges-derived object), parameters from the
Baum-Welch, and a \code{FilterParam} object.
}
\section{Slots}{

\describe{
\item{\code{.Data}}{a list. Each element of the list should be a \code{HMM} object.}
}}

\examples{
data(snp_exp)
fit <- hmm2(snp_exp)
class(fit)
identical(length(fit), ncol(snp_exp))
unlist(fit)
}
\seealso{
\code{\linkS4class{HMM}}
}
