% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LCD.R
\name{LCD}
\alias{LCD}
\title{Linear Combination Decomposition}
\usage{
LCD(in_mutation_catalogue_df, in_signatures_df, in_per_sample_cutoff = 0)
}
\arguments{
\item{in_mutation_catalogue_df}{A numeric data frame \code{V} with \code{n}
rows and \code{m} columns, \code{n} being the number of features and
\code{m} being the number of samples}

\item{in_signatures_df}{A numeric data frame \code{W} with \code{n} rows and
\code{l} columns, \code{n} being the number of features and \code{l} being
the number of signatures}

\item{in_per_sample_cutoff}{A numeric value less than 1. Signatures from
within \code{W} with an exposure per sample less than \code{in_cutoff} will
be discarded.}
}
\value{
The exposures \code{H}, a numeric data frame with \code{l} rows and
 \code{m} columns, \code{l} being the number of signatures and \code{m} being
 the number of samples
}
\description{
\code{LCD} performs a mutational signatures decomposition of a given
mutational catalogue \code{V} with known signatures \code{W} by solving the
minimization problem \eqn{min(||W*H - V||)} with additional constraints of
non-negativity on H where W and V are known
}
\examples{

## define raw data
W_prim <- matrix(c(1,2,3,4,5,6),ncol=2)
W_prim_df <- as.data.frame(W_prim)
W_df <- YAPSA:::normalize_df_per_dim(W_prim_df,2) # corresponds to the sigs
W <- as.matrix(W_df)
## 1. Simple case: non-negativity already in raw data
H <- matrix(c(2,5,3,6,1,9,1,2),ncol=4)
H_df <- as.data.frame(H) # corresponds to the exposures
V <- W \%*\% H # matrix multiplication
V_df <- as.data.frame(V) # corresponds to the mutational catalogue
exposures_df <- YAPSA:::LCD(V_df,W_df)
## 2. more complicated: raw data already contains negative elements
## define indices where sign is going to be swapped
sign_ind <- c(5,7)
## now compute the indices of the other fields in the columns affected
## by the sign change
row_ind <- sign_ind \%\% dim(H)[1]
temp_ind <- 2*row_ind -1
other_ind <- sign_ind + temp_ind
## alter the matrix H to yield a new mutational catalogue
H_compl <- H
H_compl[sign_ind] <- (-1)*H[sign_ind]
H_compl_df <- as.data.frame(H_compl) # corresponds to the exposures
V_compl <- W \%*\% H_compl # matrix multiplication
V_compl_df <- as.data.frame(V_compl) # corresponds to the mutational catalog
exposures_df <- YAPSA:::LCD(V_compl_df,W_df)
exposures <- as.matrix(exposures_df)

}
\seealso{
\code{\link[limSolve]{lsei}}
}
