% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMC.R
\name{SMC}
\alias{SMC}
\title{Stratification of a Mutational Catalogue}
\usage{
SMC(
  df_list,
  this_signatures_df,
  in_all_exposures_df,
  number_of_strata,
  number_of_sigs,
  name_list,
  this_subgroups_df,
  mutation_catalogue_all_df,
  cohort_method_flag,
  in_verbose = 1
)
}
\arguments{
\item{df_list}{A list of \code{s} stratified mutational catalogues \code{Vi}
\(numeric data frames\) with \code{n} rows and \code{m} columns each,
\code{n} being the number of features and \code{m} being the number of
samples.This list is naturally provided in \code{\link{run_SMC}}.}

\item{this_signatures_df}{A numeric data frame \code{W} in with \code{n} rows
and \code{l} columns, \code{n} being the number of features and \code{l}
being the number of signatures}

\item{in_all_exposures_df}{The overall exposures \code{H} without
stratification, a numeric data frame with \code{l} rows and \code{m}
columns, \code{l} being the number of signatures and \code{m} being the
number of samples}

\item{number_of_strata}{The length of the list \code{df_list}}

\item{number_of_sigs}{The number of signatures used in the current
decomposition.}

\item{name_list}{A list of names of the different strata}

\item{this_subgroups_df}{A data frame indicating which PID (patient or sample
identifyier) belongs to which subgroup}

\item{mutation_catalogue_all_df}{The overall mutational catalogue \code{V}
without stratification.}

\item{cohort_method_flag}{Either or several of
\code{c("all_PIDs","cohort","norm_PIDs")}, representing alternative ways to
average over the cohort.}

\item{in_verbose}{Verbose if \code{in_verbose=1}}
}
\value{
A list with entries \code{exposures_strata_list},
 \code{exposures_both_rel_df_list}, \code{this_subgroups_df},
 \code{subgroup_ind} and \code{decomposition_method}. \itemize{ \item
 \code{exposures_strata_list}: The list of \code{s} strata specific exposures
 Hi, all are numerical data frames with \code{l} rows and \code{m} columns,
 \code{l} being the number of signatures and \code{m} being the number of
 samples \item \code{exposures_both_rel_df_list}: A list of \code{s} strata
 specific cohortwide (i.e. averaged over cohort) normalized exposures \item
 \code{this_subgroups_df}: \code{subgroups_df} adjusted for plotting \item
 \code{subgroup_ind}: Index of the subgroups chosen and relevant for
 plotting. \item \code{decomposition_method}: String telling whether LCD or
 NMF was used, relevant only for handing over to \code{\link{plot_SMC}}. }
}
\description{
\code{SMC} takes a given collection of stratified mutational catalogues
\code{Vi}, sends them to perform a mutational signatures decomposition by
Linear Combination Decomposition (LCD) with the functions
\code{\link{LCD_SMC}} with known signatures \code{W}. It subsequently performs
some useful statistics and preparation for plotting with the function
\code{\link{plot_SMC}}. \code{SMC} is naturally called by
\code{\link{run_SMC}}.
}
\examples{
NULL

}
\seealso{
\code{\link{run_SMC}}

\code{\link{plot_SMC}}

\code{\link{LCD_SMC}}
}
