% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{trellis_rainfall_plot}
\alias{trellis_rainfall_plot}
\title{Create a rainfall plot in a trellis structure}
\usage{
trellis_rainfall_plot(
  in_rainfall_dat,
  in_point_size = unit(1, "mm"),
  in_rect_list = NULL,
  in_title = "",
  in_CHROM.field = "CHROM",
  in_POS.field = "POS",
  in_dist.field = "dist",
  in_col.field = "col"
)
}
\arguments{
\item{in_rainfall_dat}{Data frame which has to contain at least columns for
chromosome, position, intermutational distance and colour information}

\item{in_point_size}{size of the points in the rainfall plot to be created has
to be provided with appropriate units, e.g. in_point_size=unit(0.5,"mm")}

\item{in_rect_list}{Optional argument, if present, will lead to highlighting
of specified regions by coloured but transparent rectangles}

\item{in_title}{Title in the figure to be created.}

\item{in_CHROM.field}{String indicating which column of \code{in_rainfall_dat}
carries the chromosome information}

\item{in_POS.field}{String indicating which column of \code{in_rainfall_dat}
carries the position information}

\item{in_dist.field}{String indicating which column of \code{in_rainfall_dat}
carries the intermutational distance information}

\item{in_col.field}{String indicating which column of \code{in_rainfall_dat}
carries the colour information encoding the nucleotide exchange}
}
\value{
The function doesn't return any value.

The function doesn't return any value.
}
\description{
A trellis is a plot structure which allows space optimized multi-panel multi
track plots. This function uses the package \pkg{gtrellis} developed by
Zuguang Gu, also available at
\url{https://www.bioconductor.org/packages/release/bioc/html/gtrellis.html}.
The graphics in the tracks within a gtrellis plot are mostly drawn with
functions from the package \pkg{grid}. Note that for technical reasons, the
column indicating the chromosome MUST have the name \emph{chr} and be the
first column in the data frame supplied to the gtrellis functions. Therefore
reformatting is performed in this function before calling gtrellis functions.
}
\examples{
 data(lymphoma_test)
 choice_PID <- "4121361"
 PID_df <- subset(lymphoma_test_df,PID==choice_PID)
 trellis_rainfall_plot(PID_df,in_point_size=unit(0.5,"mm"))


}
\seealso{
\code{\link[gtrellis]{gtrellis_layout}}

\code{\link[gtrellis]{add_track}}

\code{\link[grid]{grid.points}}
}
