% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence.R
\name{variateExpSingle}
\alias{variateExpSingle}
\title{Wrapper for the likelihood ratio test}
\usage{
variateExpSingle(
  in_catalogue_vector,
  in_sig_df,
  in_exposure_vector,
  in_ind,
  in_factor = 1,
  in_pdf = NULL,
  verbose = FALSE
)
}
\arguments{
\item{in_catalogue_vector}{Mutational catalog of the input sample.}

\item{in_sig_df}{Data frame encoding the signatures used for the analysis.}

\item{in_exposure_vector}{Exposure vector computed for the input sample.}

\item{in_ind}{Index specifying which signature among \code{in_sig_df} is to
be tested.}

\item{in_factor}{Deviation factor of the altered alternative model.}

\item{in_pdf}{Probability distibution function, parameter passed on to
\link{logLikelihood} and later to \link{computeLogLik}}

\item{verbose}{Verbose if \code{in_verbose=1}}
}
\value{
Returns a list
}
\description{
Application of the likelihood ratio test to mutational signatures, primarily
for one single sample.
}
\examples{
 library(BSgenome.Hsapiens.UCSC.hg19)
 data(lymphoma_test)
 data(lymphoma_cohort_LCD_results)
 data(sigs)
 word_length <- 3
 temp_list <- create_mutation_catalogue_from_df(
   lymphoma_test_df,this_seqnames.field = "CHROM",
   this_start.field = "POS",this_end.field = "POS",
   this_PID.field = "PID",this_subgroup.field = "SUBGROUP",
   this_refGenome = BSgenome.Hsapiens.UCSC.hg19,
   this_wordLength = word_length)
 lymphoma_catalogue_df <- temp_list$matrix
 lymphoma_PIDs <- colnames(lymphoma_catalogue_df)
 data("lymphoma_cohort_LCD_results")
 lymphoma_exposures_df <-
   lymphoma_Nature2013_COSMIC_cutoff_exposures_df[, lymphoma_PIDs]
 lymphoma_sigs <- rownames(lymphoma_exposures_df)
 lymphoma_sig_df <- AlexCosmicValid_sig_df[, lymphoma_sigs]
 variateExpSingle(
   in_ind = 1,
   in_factor = 1.5,
   in_catalogue_vector = lymphoma_catalogue_df[, 1],
   in_sig_df = lymphoma_sig_df,
   in_exposure_vector = lymphoma_exposures_df[, 1])
   
}
