% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assembleSE.R
\name{assembleSE}
\alias{assembleSE}
\title{Assemble all bettr input into a SummarizedExperiment object}
\usage{
assembleSE(
  df,
  idCol = "Method",
  metrics = setdiff(colnames(df), idCol),
  initialWeights = NULL,
  initialTransforms = list(),
  metricInfo = NULL,
  metricColors = NULL,
  idInfo = NULL,
  idColors = NULL
)
}
\arguments{
\item{df}{A \code{data.frame} in wide format. Should contain one column
with the IDs of the entities to be compared, and one column for each
metric to use for the comparison.}

\item{idCol}{Character scalar, indicating the name of the column of \code{df}
and/or \code{idInfo} that contains IDs of the entities to be compared
(e.g., methods).}

\item{metrics}{Character vector, indicating which of the
columns of \code{df} that correspond to metrics of interest. Only metrics
included here will be displayed.}

\item{initialWeights}{Named numeric vector providing initial weights for
each metric to use for aggregating them into a final score. Must contain
one entry per metric included in \code{metrics}.}

\item{initialTransforms}{Named list with initial values of transformation
parameters for each metric. Each list entry should correspond to one
metric, and take the form of a list with up to four elements, named:

\if{html}{\out{<div class="sourceCode">}}\preformatted{* **flip**: Logical scalar; whether or not to flip the sign of the
    metric values. Defaults to `FALSE`.
* **offset**: Numeric scalar; offset to add to the (flipped)
    metric values. Defaults to `0`.
* **transform**: Character scalar; one of 'None', 'z-score',
    '\[0,1\]', '\[-1,1\]', 'Rank', 'Rank+\[0,1\]' or 'z-score+\[0,1\]',
    indicating which transform to apply to
    the metric values (after any flipping and/or adding the offset).
    Defaults to 'None'.
* **cuts**: Numeric vector or `NULL`; the cut points that will
    be used to bin the metric values (after the other transformations).
    Defaults to `NULL`.

Only values deviating from the defaults need to be explicitly specified,
the others will be initialized to their default values.
}\if{html}{\out{</div>}}}

\item{metricInfo}{\code{data.frame} with annotations for metrics. Must have
a column named 'Metric' identifying the respective metrics.}

\item{metricColors}{Named list with colors used for columns of
\code{metricInfo}. Should follow the format required for ComplexHeatmap
heatmap annotations. The list can include an entry named 'Metric', which
contains a named vector with colors to use for metrics.}

\item{idInfo}{\code{data.frame} with annotations for entities. Must have a
column named according to \code{idCol} identifying the respective entities.}

\item{idColors}{Named list with colors used for columns of \code{idInfo}.
Should follow the format required for ComplexHeatmap heatmap
annotations. The list can include an entry named according to \code{idCol},
which contains a named vector with colors to use for entities.}
}
\value{
A SummarizedExperiment object with rows corresponding to methods and columns
corresponding to metrics.
}
\description{
Assemble all bettr input into a \code{SummarizedExperiment} object. This
has the advantage of keeping all data together in a single object, and can
be used as input to \code{bettr} or \code{bettrGetReady}, instead of
providing the individual components.
}
\examples{
df <- data.frame(Method = c("M1", "M2", "M3"),
                 metric1 = c(1, 2, 3),
                 metric2 = c(3, 1, 2))
metricInfo <- data.frame(Metric = c("metric1", "metric2", "metric3"),
                         Group = c("G1", "G2", "G2"))
idInfo <- data.frame(Method = c("M1", "M2", "M3"),
                     Type = c("T1", "T1", "T2"))
bettrSE <- assembleSE(df = df, metricInfo = metricInfo, idInfo = idInfo)

}
\author{
Charlotte Soneson
}
