% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichItPlot.R
\name{enrichItPlot}
\alias{enrichItPlot}
\title{Adaptive Visualisation of enrichIt Results}
\usage{
enrichItPlot(
  res,
  plot.type = c("bar", "dot", "cnet"),
  top = 20,
  x.measure = "-log10(padj)",
  color.measure = x.measure,
  show.counts = TRUE,
  palette = "inferno",
  ...
)
}
\arguments{
\item{res}{Data frame. Output from \code{\link{enrichIt}}.}

\item{plot.type}{Character. Visualization type. Options:
\itemize{
  \item \code{"bar"} (default): Horizontal bar plot.
  \item \code{"dot"}: Dot plot with size and color encoding.
  \item \code{"cnet"}: Concept network plot showing gene-pathway
    relationships.
}}

\item{top}{Integer. Keep the top \emph{n} terms \strong{per database}
(ranked by adjusted p-value). Set to \code{Inf} to keep all. Default is
\code{20}.}

\item{x.measure}{Character. Column in \code{res} mapped to the x-axis
(ignored for \code{"cnet"}). Default is \code{"-log10(padj)"}.}

\item{color.measure}{Character. Column mapped to color (dot plot only).
Default is same as \code{x.measure}.}

\item{show.counts}{Logical. If \code{TRUE}, annotate bar plot with the
\code{Count} (number of genes). Default is \code{TRUE}.}

\item{palette}{Character. Color palette name from
\code{\link[grDevices]{hcl.pals}}. Default is \code{"inferno"}.}

\item{...}{Further arguments passed to \pkg{ggplot2} geoms (e.g.,
\code{alpha}, \code{linewidth}).}
}
\value{
A \pkg{ggplot2} object (bar/dot) or \pkg{ggraph} object (cnet).
}
\description{
Create bar, dot, or network plots from \code{\link{enrichIt}} results.
}
\examples{
\dontrun{
ranks <- setNames(markers$avg_log2FC, rownames(markers))
gs    <- getGeneSets("Homo sapiens", library = c("H", "C2"))
res   <- enrichIt(ranks, gs)

enrichItPlot(res)               
enrichItPlot(res, "dot", top=10) 
enrichItPlot(res, "cnet", top=5) 
}
}
