% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gseaEnrichment.R
\name{gseaEnrichment}
\alias{gseaEnrichment}
\title{Classical GSEA-style Running-Enrichment Plot}
\usage{
gseaEnrichment(
  input.data,
  gene.set.use,
  gene.sets,
  group.by = NULL,
  summary.fun = "mean",
  p = 1,
  nperm = 1000,
  rug.height = 0.02,
  digits = 2,
  BPPARAM = NULL,
  palette = "inferno"
)
}
\arguments{
\item{input.data}{A \link[SeuratObject]{Seurat} object or a
\link[SingleCellExperiment]{SingleCellExperiment}.}

\item{gene.set.use}{Character. Name of the gene set to display.}

\item{gene.sets}{A named list of character vectors, the result of
\code{\link{getGeneSets}}, or the built-in data object
\code{\link{escape.gene.sets}}.}

\item{group.by}{Character. Metadata column used for grouping. Defaults to
the Seurat/SCE \code{ident} slot when \code{NULL}.}

\item{summary.fun}{Character. Method used to collapse expression within
each group \strong{before} ranking. One of: \code{"mean"} (default),
\code{"median"}, \code{"max"}, \code{"sum"}, or \code{"geometric"}.}

\item{p}{Numeric. Weighting exponent in the KS statistic. Classical GSEA
uses \code{p = 1}. Default is \code{1}.}

\item{nperm}{Integer. Number of gene-label permutations per group.
Default is \code{1000}. Set to \code{0} to skip NES/p-value calculation.}

\item{rug.height}{Numeric. Vertical spacing of the hit rug as a fraction
of the y-axis. Default is \code{0.02}.}

\item{digits}{Integer. Number of decimal places displayed for ES in the
legend. Default is \code{2}.}

\item{BPPARAM}{A \pkg{BiocParallel} parameter object describing the
parallel backend. Default is \code{NULL} (serial execution).}

\item{palette}{Character. Color palette name from
\code{\link[grDevices]{hcl.pals}}. Default is \code{"inferno"}.}
}
\value{
A single `patchwork`/`ggplot2` object
}
\description{
Produces the familiar two-panel GSEA graphic: running enrichment score (RES)
plus a "hit" rug for a \strong{single gene-set} evaluated across multiple
biological groups (clusters, conditions, samples, etc.).
}
\section{Algorithm}{

Based on Subramanian \emph{et al.}, PNAS 2005:
\enumerate{
  \item Within every group, library-size-normalize counts to CPM.
  \item Collapse gene expression with \code{summary.fun} (mean/median/etc.).
  \item Rank genes (descending) to obtain one ordered list per group.
  \item Compute the weighted Kolmogorov-Smirnov running score
    (weight = |stat|^p).
  \item ES = maximum signed deviation of the curve.
}
}

\examples{
pbmc_small <- SeuratObject::pbmc_small

gs <- list(Bcells = c("MS4A1", "CD79B", "CD79A", "IGH1", "IGH2"),
           Tcells = c("CD3E", "CD3D", "CD3G", "CD7","CD8A"))

gseaEnrichment(pbmc_small,
               gene.set.use = "Bcells",
               gene.sets    = gs,
               group.by     = "groups",
               summary.fun  = "mean",
               digits       = 3)

}
\seealso{
\code{\link{escape.matrix}}, \code{\link{densityEnrichment}}
}
