% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_symbol.R
\name{add_symbol}
\alias{add_symbol}
\title{Adding symbols to each spot in the spatial map}
\usage{
add_symbol(p, var, size = 1, ...)
}
\arguments{
\item{p}{a spatial map created by \code{make_escheR()}, with or without other layers of aesthetics.}

\item{var}{A character(1) with the name of the colData(spe) column that has the values to be used as the background.}

\item{size}{A numeric(1) specifying the size of the symbols in the ggplot. Defaults to 1.}

\item{...}{Reserved for future arguments.}
}
\value{
an ggplot object.
}
\description{
Adding symbols to each spot in the spatial map
}
\examples{
library(STexampleData)

spe <- Visium_humanDLPFC()

# Convert a continuous variable to categorical
spe$in_tissue <- factor(spe$in_tissue)

make_escheR(spe) |>
    add_ground(var = "ground_truth") |>
    add_symbol(var = "in_tissue", size = 0.5)
}
