% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counts.R
\name{faers_counts}
\alias{faers_counts}
\alias{faers_counts,FAERSascii-method}
\title{Counting the number of unique case for each event}
\usage{
faers_counts(.object, ...)

\S4method{faers_counts}{FAERSascii}(
  .object,
  .events = "soc_name",
  .fn = NULL,
  ...,
  .field = "reac",
  .na.rm = FALSE
)
}
\arguments{
\item{.object}{A \link{FAERSascii} object.}

\item{...}{Other arguments passed to specific methods, for \code{FAERSascii}
method, other arguments passed to \code{.fn()}.}

\item{.events}{A character specify the events column(s) in the \code{.field} data
to count the unique \code{primaryid}. If multiple columns were selected, the
combination for all columns will define the interested events.}

\item{.fn}{A function or formula defined the preprocessing function before
creating contingency table, with the \code{.field} data as the input and return a
\link[data.table:data.table]{data.table}.

Note: When using the \verb{set*} or \verb{:=} function from \code{data.table} with the
"demo", "drug", "ther", "rpsr", and "outc" data, exercise caution as these
functions directly modify the internal data. In such cases, it is advisable
to use the \link[data.table:copy]{copy} function first.

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function with up to
two arguments: \code{.x} (single argument) or \code{.x} and \code{.y} (two arguments). The
\code{.} placeholder can be used instead of \code{.x}.  This allows you to create
very compact anonymous functions (lambdas) with up to two inputs.

If a \strong{string}, the function is looked up in \code{globalenv()}.}

\item{.field}{A string indicates the interested FAERS fields to
use. Only values "demo", "drug", "indi", "ther", "reac", "rpsr", and "outc"
can be used.}

\item{.na.rm}{A bool, whether \code{NA} value in \code{.events} column(s) should be
removed.}
}
\value{
A \link[data.table:data.table]{data.table} object.
}
\description{
Counting the number of unique case for each event
}
\examples{
# you must change `dir`, as the files included in the package are sampled
data <- faers(c(2004, 2017), c("q1", "q2"),
    dir = system.file("extdata", package = "faers"),
    compress_dir = tempdir()
)
\dontrun{
# you must standardize and deduplication before disproportionality analysis
# you should replace `meddra_path` with yours
data <- faers_standardize(data, meddra_path)
data <- faers_dedup(data)
faers_counts(data)
}
std_data <- readRDS(system.file("extdata", "standardized_data.rds",
    package = "faers"
))
faers_counts(std_data)
}
