% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fda_drugs.R
\name{fda_drugs}
\alias{fda_drugs}
\title{Read and Parse Drugs@FDA data}
\usage{
fda_drugs(pattern = "Products", url = NULL, list = FALSE, force = FALSE)
}
\arguments{
\item{pattern}{File pattern to use. Must define a file exactly, you can set
\code{list = TRUE} to see what files can be used.}

\item{url}{A string of the url for \code{Drugs@FDA} file. Try to get the link
from site:
\url{https://www.fda.gov/drugs/drug-approvals-and-databases/drugsfda-data-files}.}

\item{list}{A boolean value, should it only list files in the \code{Drugs@FDA}
dataset?}

\item{force}{A boolean value. If set to \code{TRUE}, it indicates the retrieval of
\code{Drugs@FDA} data in the FDA directly, bypassing the cache.}
}
\value{
\itemize{
\item if \code{list = TRUE}, an atomic character.
\item if \code{list = FALSE}, a \link[data.table:data.table]{data.table}.
}
}
\description{
Read and Parse Drugs@FDA data
}
\examples{
fda_drugs(list = TRUE)
fda_drugs()
}
