% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{makeOrgGatomAnnotation}
\alias{makeOrgGatomAnnotation}
\title{Create an organism annotation object for network analysis}
\usage{
makeOrgGatomAnnotation(
  org.db,
  idColumns = c(Entrez = "ENTREZID", RefSeq = "REFSEQ", Ensembl = "ENSEMBL", Symbol =
    "SYMBOL"),
  nameColumn = "SYMBOL",
  enzymeColumn = "ENZYME",
  appendEnzymesFromKegg = TRUE,
  appendOrthologiesFromKegg = TRUE,
  filterNonSpecificEnzymes = TRUE,
  keggOrgCode = NULL
)
}
\arguments{
\item{org.db}{Bioconductor org.db object, e.g. org.Mm.eg.db}

\item{idColumns}{vector of column names from `org.db` object to creat ID mappings.
First ID will be used as a base identifier, should be compatible
with KEGG and Reactome databases.}

\item{nameColumn}{column with a human readable gene symbol. Default to "SYMBOL".}

\item{enzymeColumn}{column with an Enzyme Commission ID. Default to "ENZYME".}

\item{appendEnzymesFromKegg}{if TRUE, KEGG databases will be sued to extend gene to
enzyme mappings obtained from org.db package.}

\item{appendOrthologiesFromKegg}{if TRUE, KEGG database will be sued to extend gene to
orthology mappings obtained from org.db package}

\item{filterNonSpecificEnzymes}{if TRUE, will filter out non-specific enzymes from
gene to enzyme mappings obtained from org.db package}

\item{keggOrgCode}{KEGG organism code, e.g. "mmu". If set to NULL, the code is determined
automatically.}
}
\value{
organism annotation object that will be used for network analysis
}
\description{
Create an organism annotation object for network analysis
}
\examples{
library(org.Mm.eg.db)
org.Mm.eg.gatom.anno <- makeOrgGatomAnnotation(org.db = org.Mm.eg.db)

}
