% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsets.R
\name{gsets}
\alias{gsets}
\title{A genesets object}
\description{
A genesets object

A genesets object
}
\section{See Also}{


\code{rgsets}
}

\examples{
genesets <- list("GSET1" = c("GENE1", "GENE2", "GENE3"),
                 "GSET2" = c("GENE4", "GENE5", "GENE6"),
                 "GSET3" = c("GENE7", "GENE8", "GENE9"))

gsets_obj <- gsets$new(genesets, name="example", version="v1.0")
print(gsets_obj)

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{genesets}}{A named list of genesets}

\item{\code{name}}{A character vector describing source of genesets}

\item{\code{version}}{A character vector describing versioning}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-gsets-new}{\code{gsets$new()}}
\item \href{#method-gsets-print}{\code{gsets$print()}}
\item \href{#method-gsets-list}{\code{gsets$list()}}
\item \href{#method-gsets-info}{\code{gsets$info()}}
\item \href{#method-gsets-reduce}{\code{gsets$reduce()}}
\item \href{#method-gsets-clone}{\code{gsets$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gsets-new"></a>}}
\if{latex}{\out{\hypertarget{method-gsets-new}{}}}
\subsection{Method \code{new()}}{
Create a gsets object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{gsets$new(
  genesets,
  name = "Custom",
  version = "",
  clean = FALSE,
  quiet = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{genesets}}{A named list of genesets}

\item{\code{name}}{A character vector describing source of genesets}

\item{\code{version}}{A character vector describing versioning}

\item{\code{clean}}{Use true to clean labels of genesets}

\item{\code{quiet}}{Use true to silence warnings}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new gsets object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gsets-print"></a>}}
\if{latex}{\out{\hypertarget{method-gsets-print}{}}}
\subsection{Method \code{print()}}{
Print genesets information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{gsets$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gsets-list"></a>}}
\if{latex}{\out{\hypertarget{method-gsets-list}{}}}
\subsection{Method \code{list()}}{
Return genesets as a list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{gsets$list()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of genesets
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gsets-info"></a>}}
\if{latex}{\out{\hypertarget{method-gsets-info}{}}}
\subsection{Method \code{info()}}{
Returns versioning information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{gsets$info()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector with name and version
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gsets-reduce"></a>}}
\if{latex}{\out{\hypertarget{method-gsets-reduce}{}}}
\subsection{Method \code{reduce()}}{
Reduces genesets to a background distribution of symbols
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{gsets$reduce(background)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{background}}{A character vector of symbols}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A gsets object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gsets-clone"></a>}}
\if{latex}{\out{\hypertarget{method-gsets-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{gsets$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
