% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{IsomirDataSeqFromFiles}
\alias{IsomirDataSeqFromFiles}
\title{Loads miRNA annotation from seqbuster tool or pre-processed data.}
\usage{
IsomirDataSeqFromFiles(
  files,
  coldata,
  rate = 0.2,
  canonicalAdd = TRUE,
  uniqueMism = TRUE,
  uniqueHits = FALSE,
  design = ~1L,
  minHits = 1L,
  header = TRUE,
  skip = 0,
  quiet = TRUE,
  ...
)
}
\arguments{
\item{files}{files with the output of seqbuster tool}

\item{coldata}{data frame containing groups for each sample}

\item{rate}{minimum counts fraction to consider a mismatch a real mutation}

\item{canonicalAdd}{\code{boolean} only keep A/T non-template addition.
All non-template nucleotides at the 3' end will be removed if they
contain C/G nts.}

\item{uniqueMism}{\code{boolean} only keep mutations that have
a unique hit to one miRNA molecule. For instance, if the sequence map
to two different miRNAs, then it would be removed.}

\item{uniqueHits}{\code{boolean} whether filtering ambigous sequences or not.}

\item{design}{a \code{formula} to pass to \link[DESeq2:DESeqDataSet]{DESeq2::DESeqDataSet}}

\item{minHits}{Minimum number of reads in the sample to consider it
in the final matrix.}

\item{header}{boolean to indicate files contain headers}

\item{skip}{skip first line when reading files}

\item{quiet}{boolean indicating to print messages
while reading files. Default \code{FALSE}.}

\item{...}{arguments provided to
\code{SummarizedExperiment} and \link{IsomirDataSeqFromRawData}.
including rowData.}
}
\value{
\link{IsomirDataSeq} class object.
}
\description{
This function parses
output of seqbuster tool to allow isomiRs/miRNAs analysis of samples
in different groups such as
characterization, differential expression and clustering. It creates an
\link{IsomirDataSeq} object.
}
\details{
This function parses the output of
http://seqcluster.readthedocs.org/mirna_annotation.html
for each sample to create a count matrix for isomiRs, miRNAs or
isomiRs grouped in
types (i.e all sequences with variations at 5' but ignoring any other type).
It creates
\link{IsomirDataSeq} object (see link to example usage of
this class)
to allow visualization, queries, differential
expression analysis and clustering.
To create the \link{IsomirDataSeq}, it parses the isomiRs
files, and generates
an initial matrix having all isomiRs detected among samples. As well,
it creates
a summary for each isomiR type (trimming, addition and substitution) to
visualize general isomiRs distribution.
}
\examples{
path <- system.file("extra", package="isomiRs")
fn_list <- list.files(path, pattern="mirna", full.names = TRUE)
de <- data.frame(row.names=c("f1" , "f2"),
                 condition = c("newborn", "newborn"))
ids <- IsomirDataSeqFromFiles(fn_list, coldata=de)

head(counts(ids))
IsomirDataSeqFromRawData(metadata(ids)[["rawData"]], de)
}
