% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{IsomirDataSeqFromMirtop}
\alias{IsomirDataSeqFromMirtop}
\title{Import \code{mirtop} output into \code{IsomirDataSeq}}
\usage{
IsomirDataSeqFromMirtop(mirtop, coldata, ...)
}
\arguments{
\item{mirtop}{data.frame with the output of \verb{mirtop export}}

\item{coldata}{data.frame with the metadata of the samples}

\item{...}{It supports the same parameters as in \link{IsomirDataSeqFromRawData}.}
}
\value{
\link{IsomirDataSeq} class object.
}
\description{
The tabular output of \url{mirtop} is compatible with \link{IsomirDataSeq}. This
function allows to import the data and filter low confidence isomiRs for
downstream analysis.
}
\details{
The output is generated with \verb{mirtop export --format isomir}.
}
\examples{
library(readr)
path <- system.file("extra", "mirtop", package="isomiRs")
fn <- list.files(path, full.names = TRUE)
de <- data.frame(row.names=c("sample1" , "sample2"),
                 condition = c("cc", "cc"))
# mirtop export --format isomir ....
IsomirDataSeqFromMirtop(read_tsv(fn), de)
}
