% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformationFunctions.R
\name{applyInheritanceModel}
\alias{applyInheritanceModel}
\alias{applyInheritanceModel.matrix}
\alias{applyInheritanceModel.SummarizedExperiment}
\title{Apply inheritance model}
\usage{
applyInheritanceModel(
  experiment,
  inheritance_model = c("dominant", "recessive", "additive", "overdominant")
)

\method{applyInheritanceModel}{matrix}(
  experiment,
  inheritance_model = c("dominant", "recessive", "additive", "overdominant")
)

\method{applyInheritanceModel}{SummarizedExperiment}(
  experiment,
  inheritance_model = c("dominant", "recessive", "additive", "overdominant")
)
}
\arguments{
\item{experiment}{Matrix or SummarizedExperiment object.}

\item{inheritance_model}{String specifying inheritance model to use.
Available choices are \code{"dominant"}, \code{"recessive"},
\code{"additive"}.}
}
\value{
\code{experiment} converted to specified inheritance model.
}
\description{
Helper function transforming experiment counts to selected
\code{inheritance_model}.
}
\details{
Under \code{"dominant"} model homozygotes and heterozygotes are coded as
\code{1}. In \code{"recessive"} model homozygotes are coded as \code{1} and
other as \code{0}. In \code{"additive"} model homozygotes are coded as
\code{2} and heterozygotes as \code{1}. In \code{"overdominant"} homozygotes
(both \code{0} and \code{2}) are coded as \code{0} and heterozygotes as \code{1}.
}
