% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_dis.R
\name{net_dis,mina,ANY-method}
\alias{net_dis,mina,ANY-method}
\alias{net_dis,mina,character-method}
\title{Calculate the network distance of `multi` and test the significance when
`perm` is defined.}
\usage{
\S4method{net_dis}{mina,ANY}(
  x,
  method,
  evk = 100,
  egv = TRUE,
  dir = "./",
  sig = TRUE,
  skip = TRUE,
  ...
)

\S4method{net_dis}{mina,character}(
  x,
  method,
  evk = 100,
  egv = TRUE,
  dir = "./",
  sig = TRUE,
  skip = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class `mina` with `multi` (and `perm` if sig is TRUE)
defined.}

\item{method}{The distance to be calculated, "spectra" and "Jaccard" are
available.}

\item{evk}{The first `evk` eigenvalues will be used for `spectra` distance,
the default is 100.}

\item{egv}{Wheather to output the eigenvectors for Spectral distance, the
defult is TRUE, only validate when `method == "spectra"`.}

\item{dir}{The folder to output the eigenvectors, only validate when `egv ==
TRUE`.}

\item{sig}{Whether to test the significance, if TRUE (by default), `perm` is
needed.}

\item{skip}{Whether to skip the comparison when the dimenstion of adjacency
matrix is smaller than setted `evk`.}

\item{...}{Additional parameters.}
}
\value{
x The same `mina` object with `net_dis` defined.
}
\description{
Calculate the network distance of `multi` and test the significance when
`perm` is defined.
}
\examples{
maize <- new("mina", tab = maize_asv2, des = maize_des2)
maize <- norm_tab(maize, method = "raref")
maize <- fit_tabs(maize)
maize <- bs_pm(maize, group = "Compartment")
maize <- net_dis(maize, method = "Jaccard")
}
