% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R, R/net_dis_indi.R
\name{net_dis_indi}
\alias{net_dis_indi}
\alias{net_dis_indi,character,ANY-method}
\alias{net_dis_indi,character,character-method}
\title{Calculate the network distance of bootstrap and permutation when appliable.}
\usage{
net_dis_indi(x, method, ...)

\S4method{net_dis_indi}{character,ANY}(
  x,
  method,
  evk = 100,
  sig = TRUE,
  skip = TRUE,
  egv = TRUE,
  dir = "./",
  ...
)

\S4method{net_dis_indi}{character,character}(
  x,
  method,
  evk = 100,
  sig = TRUE,
  skip = TRUE,
  egv = TRUE,
  dir = "./",
  ...
)
}
\arguments{
\item{x}{The folder store the network inference results.
defined.}

\item{method}{The distance to be calculated, "spectra" and "Jaccard" are
available.}

\item{...}{Additional parameters.}

\item{evk}{The first `evk` eigenvalues will be used for `spectra` distance,
the default is 100.}

\item{sig}{Whether to test the significance, if TRUE (by default),
permutation results should be included in the folder `x`.}

\item{skip}{Whether to skip the comparison when the dimenstion of adjacency
matrix is smaller than setted `evk`, default TRUE.}

\item{egv}{Wheather to output the eigenvectors for Spectral distance, the
defult is TRUE, only validate when `method == "spectra"`.}

\item{dir}{The folder to output the eigenvectors, only validate when `egv ==
TRUE`.}
}
\value{
y The `mina` object with `dis_bs`, `dis_pm` and `dis_stat`.

y The `mina` object with `dis_bs`, `dis_pm` and `dis_stat`.
}
\description{
Calculate the network distance of bootstrap and permutation when appliable.

Calculate the network distance of bootstrap and permutation when appliable.
}
\examples{
\dontrun{
data(maize)
maize <- norm_tab(maize, method = "raref")
maize <- fit_tabs(maize)
maize <- get_rep(maize, top = 5)
maize <- bs_pm(maize, group = "Compartment", individual = TRUE, out_dir =
"./individual_bs_pm/")
maize_stat1 <- net_dis_indi(x = "./individual_bs_pm/", method = "spectra")
maize_stat2 <- net_dis_indi(x = "./individual_bs_pm/", method = "Jaccard")
maize_stat3 <- net_dis_indi(x = "./individual_bs_pm/", method = "spectra",
evk = 100, skip = TRUE)
}
\dontrun{
data(maize)
norm(maize) <- maize_asv2
maize <- fit_tabs(maize)
maize <- get_rep(maize, top= 5)
maize <- bs_pm(maize, group = "Compartment", individual = TRUE, out_dir =
"./individual_bs_pm/")
maize_stat1 <- net_dis_indi("./individual_bs_pm/", method = "spectra")
maize_stat2 <- net_dis_indi("./individual_bs_pm/", method = "Jaccard")
maize_stat3 <- net_dis_indi("./individual_bs_pm/", method = "spectra",
evk = 100, skip = TRUE)
}
}
