% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view-composers.R
\name{add_paraview}
\alias{add_paraview}
\title{Generate and add a paraview to the current view composition}
\usage{
add_paraview(
  current.views,
  positions,
  l,
  zoi = 0,
  family = c("gaussian", "exponential", "linear", "constant"),
  approx = 1,
  nn = NULL,
  prefix = "",
  cached = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{current.views}{the current view composition.}

\item{positions}{a \code{data.frame}, \code{tibble} or a \code{matrix}
with named coordinates in columns and rows for each spatial unit ordered
as in the intraview.}

\item{l}{effective radius of influence of expression in the broader tissue
structure.}

\item{zoi}{spatial units with distance smaller than the zone of indifference
will not be taken into account when generating the paraview.}

\item{family}{the family f functions used to generate weights. (see Details)}

\item{approx}{rank of the Nyström approximation matrix. (see Details)}

\item{nn}{the number of spatial units to be used for approximating the
paraview using a fast nearest neighbor search. (see Details)}

\item{prefix}{a prefix to add to the column names.}

\item{cached}{a \code{logical} indicating whether to cache the calculated view
after the first calculation and to reuse a previously cached view if it
already exists for this sample.}

\item{verbose}{a \code{logical} controlling the verbosity of the output of the
function during execution.}
}
\value{
A mistyR view composition with added paraview with parameter \code{l}.
}
\description{
The paraview captures the expression of all markers in  the broader
tissue structure.
}
\details{
The paraview is generated by weighted sum of the expression of all spatial
units for each marker. The weights for each spatial unit \var{i} are dependent
on the \code{family} which can be one of "gaussian", "exponential", "linear"
or "constant".

If "gaussian" the weights are calculated based on the distance to the spatial
unit \var{j} and the parameter \code{l} using the radial basis function
\deqn{w_{ij} = e^{-\frac{d_{ij}^2}{l^2}}}{w(i,j) = exp(-d(i,j)^2/l^2)}

The parameter \code{l} here denotes the "effective" radius of influence.

If "exponential" the weights are calculated based on the distance to the spatial
unit \var{j} and the parameter \code{l} using the exponential function
\deqn{w_{ij} = e^{-\frac{d_{ij}}{l}}}{w(i,j) = exp(-d(i,j)/l)}

The parameter \code{l} here denotes signaling length. For more information
consult Oyler-Yaniv et. al. Immunity 46(4) 2017.

If "linear" the weights are calculated based on the distance to the spatial
unit \var{j} and the parameter \code{l} using the linear function
\deqn{w_{ij} = 1- d(i,j)/l}{w(i,j) = 1- d(i,j)/l}

The parameter \code{l} here denotes the intersect of the linear function. For
distances larger than \code{l} the weight is equal to 0.

If "constant" the weights are always 1. The parameter \code{l} here denotes
the number of nearest neighbors to take into account if \code{nn} is not
defined.

Since the generation of the paraview requires the calculation of pairwise distances
of all spatial units it can take a significant amount of computation time. The
parameters \code{approx} and \code{nn} can be set to speed up the calculation
by approximation. The approximation can be achieved by using the Nyström
low-rank approximation method or by limiting the calculation of the paraview
to a number of nearest neighbors around each spatial unit.

If the value of \code{approx} is between 0 and 1 it will be interpreted as
fraction of the number of spatial units. Discrete values above 1 will be
interpreted as the size of the approximation block. The number of nearest
neighbors \code{nn} around each spatial unit are determined using a fast
nearest neighbor search.

If both \code{approx} and \code{nn} have non-null values, \code{nn}
has priority and an approximation based on fast nearest neighbor
search will be used to generate the paraview.
}
\examples{
# Create a view composition of an intraview and a paraview with radius 10.

library(dplyr)

# get the expression data
data("synthetic")
expr <- synthetic[[1]] \%>\% select(-c(row, col, type))
# get the coordinates for each cell
pos <- synthetic[[1]] \%>\% select(row, col)

# compose
misty.views <- create_initial_view(expr) \%>\% add_paraview(pos, l = 10)

# preview
str(misty.views[["paraview.10"]])
}
\seealso{
\code{\link{create_initial_view}()} for
    starting a view composition with an intraview only.

Other view composition functions: 
\code{\link{add_juxtaview}()},
\code{\link{add_views}()},
\code{\link{create_initial_view}()},
\code{\link{create_view}()},
\code{\link{remove_views}()}
}
\concept{view composition functions}
