% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{extract_signature}
\alias{extract_signature}
\title{Extract signatures from the results}
\usage{
extract_signature(
  misty.results,
  type = c("performance", "contribution", "importance"),
  trim = -Inf,
  trim.measure = c("gain.R2", "multi.R2", "intra.R2", "gain.RMSE", "multi.RMSE",
    "intra.RMSE")
)
}
\arguments{
\item{misty.results}{a results list generated by
\code{\link{collect_results}()}.}

\item{type}{type of signature to extract from the results.}

\item{trim}{display targets with performance value above (if R2 or gain) or
below (otherwise) this value only.}

\item{trim.measure}{the measure used for trimming.}
}
\value{
A table with one row per sample from \code{misty.results} representing
its signature.
}
\description{
Signature is a representation of each sample in the space of mistyR results.
}
\details{
The performance signature of each sample is a concatenation of the estimated
values of variance explained using only the intraview, the variance explained
by the multiview model and the gain in variance explained for each marker.
The performance signature vector for each sample available in
\code{misty.results} is of length \eqn{\textrm{markers} \cdot 3}{markers x 3}.

The contribution signature of each sample is a concatenation of the estimated
fraction of contribution of each view for each marker.
The contribution signature vector for each sample available in
\code{misty.results} is of length
\eqn{\textrm{markers} \cdot \textrm{views}}{markers x views}.

The importance signature of each sample is a concatenation of the estimated
and weighted importances for each predictor-target marker pair from all views.
The importance signature vector for each sample available in
\code{misty.results} is of length
\eqn{\textrm{markers}^2 \cdot \textrm{views}}{markers^2 x views}.
}
\examples{
library(dplyr)

misty.results <-
  list.files("results", full.names = TRUE) \%>\% collect_results()

extract_signature(misty.results, "performance")
}
\seealso{
\code{\link{collect_results}()} to generate a
    results list from raw results.
}
